/*
 * Decompiled with CFR 0.152.
 */
package IE.Iona.OrbixWeb.Activator;

import IE.Iona.OrbixWeb.Activator.ActiveServer;
import IE.Iona.OrbixWeb.Activator.ClassLauncher;
import IE.Iona.OrbixWeb.Activator.DJException;
import IE.Iona.OrbixWeb.Activator.DJNVList;
import IE.Iona.OrbixWeb.Activator.DefActiveServer;
import IE.Iona.OrbixWeb.Activator.DefImplFinder;
import IE.Iona.OrbixWeb.Activator.LaunchArguments;
import IE.Iona.OrbixWeb.Activator.LaunchRecord;
import IE.Iona.OrbixWeb.Activator.LaunchTable;
import IE.Iona.OrbixWeb.Activator.ServerEntry;
import IE.Iona.OrbixWeb.Activator.ServerManager;
import IE.Iona.OrbixWeb.CORBA.ErrorMsgs;
import IE.Iona.OrbixWeb.CORBA.NVList;
import IE.Iona.OrbixWeb.Features.Config;
import IE.Iona.OrbixWeb._CORBA;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.SystemException;

public class DefServerManager
implements ServerManager {
    private String serverName;
    private String serverContext;
    private NVList details;
    private DefImplFinder finder;

    public DefServerManager(String string, NVList nVList, DefImplFinder defImplFinder) {
        this.serverName = string;
        this.details = nVList;
        this.finder = defImplFinder;
        this.serverContext = null;
    }

    public String name() {
        return this.serverName;
    }

    public String context() {
        return this.serverContext;
    }

    public NVList details() {
        return this.details;
    }

    public ActiveServer[] active() {
        Vector<LaunchRecord> vector = new Vector<LaunchRecord>(5, 5);
        LaunchTable launchTable = DefImplFinder.launchedServers;
        Enumeration enumeration = launchTable.elements();
        while (enumeration.hasMoreElements()) {
            LaunchRecord launchRecord = null;
            try {
                launchRecord = (LaunchRecord)enumeration.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {}
            if (!launchRecord.getServerName().equals(this.serverName)) continue;
            vector.addElement(launchRecord);
        }
        return this.toActiveServerArray(vector);
    }

    public ActiveServer[] toActiveServerArray(Vector vector) {
        ActiveServer[] activeServerArray = new ActiveServer[vector.size()];
        LaunchRecord launchRecord = null;
        int n = 0;
        while (n < vector.size()) {
            try {
                launchRecord = (LaunchRecord)vector.elementAt(n);
                activeServerArray[n] = new DefActiveServer(launchRecord);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            ++n;
        }
        return activeServerArray;
    }

    public void update(NVList nVList) throws SystemException {
        if (nVList == null) {
            DJException.throw_BAD_PARAM_Exception(12021, "");
        }
        if (nVList.count() >= 2) {
            try {
                if (nVList.item(0).name().equals("MARKERS") && nVList.item(1).name().equals("COMMANDS")) {
                    String[] stringArray = DJNVList.getStringArrayFromNVList(0, nVList);
                    String[] stringArray2 = DJNVList.getStringArrayFromNVList(1, nVList);
                    this.updateMarker(stringArray[0], stringArray2[0]);
                    return;
                }
            }
            catch (Bounds bounds) {
                return;
            }
        }
    }

    public void flush(ServerEntry serverEntry) {
        String string = this.context();
        String string2 = this.name();
        NVList nVList = serverEntry.details();
        this.finder.removeImpRepFile(string, string2);
        try {
            this.finder.createImpRepFile(string, string2, nVList);
            return;
        }
        catch (Exception exception) {
            this.finder.removeImpRepFile(string, string2);
            DJException.throw_BAD_OPERATION_Exception(10145, string2);
            return;
        }
    }

    private void updateMarker(String string, String string2) throws SystemException {
        ServerEntry serverEntry = null;
        if (string == null) {
            DJException.throw_BAD_PARAM_Exception(10030, "");
        }
        boolean bl = string.indexOf(58) == -1 && string.indexOf(32) == -1;
        bl = false;
        if (false) {
            DJException.throw_BAD_PARAM_Exception(10030, string);
        }
        if ((serverEntry = this.finder.updateMarker(this.name(), string, string2)) != null) {
            this.flush(serverEntry);
        }
    }

    public static boolean validateServerName(String string) {
        return string.indexOf(58) == -1 && string.indexOf(32) == -1;
    }

    public static boolean validateMarker(String string) {
        return string.indexOf(58) == -1 && string.indexOf(32) == -1;
    }

    public ActiveServer load(NVList nVList) throws SystemException {
        int n = 0;
        String string = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string2 = null;
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        String string3 = null;
        String string4 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        try {
            int n6 = n++;
            string = nVList.item(n6).value().extract_string();
            stringArray = DJNVList.getStringArrayFromNVList(n++, nVList);
            stringArray2 = DJNVList.getStringArrayFromNVList(n++, nVList);
            n6 = n++;
            n2 = nVList.item(n6).value().extract_long();
            n6 = n++;
            string2 = nVList.item(n6).value().extract_string();
            if (n2 == 0) {
                string2 = "";
            }
            stringArray3 = DJNVList.getStringArrayFromNVList(n++, nVList);
            stringArray4 = DJNVList.getStringArrayFromNVList(n++, nVList);
            n6 = n++;
            n3 = nVList.item(n6).value().extract_long();
            n6 = n++;
            n4 = nVList.item(n6).value().extract_long();
            n6 = n++;
            n5 = nVList.item(n6).value().extract_long();
            n6 = n++;
            string3 = nVList.item(n6).value().extract_string();
            n6 = n++;
            string4 = nVList.item(n6).value().extract_string();
        }
        catch (Exception exception) {
            DJException.throw_BAD_CONTEXT_Exception(10443, "");
        }
        String string5 = stringArray.length == 0 ? "*" : stringArray[0];
        void var16_17 = stringArray2[0];
        if (n2 != 0) {
            throw new NO_IMPLEMENT(ErrorMsgs.getMessage(12805, ""), 12805, CompletionStatus.COMPLETED_NO);
        }
        DefActiveServer defActiveServer = (DefActiveServer)this.getActiveServer(string, string5, string2);
        if (defActiveServer != null) {
            if (defActiveServer.isDisconnected()) {
                DJException.throw_BAD_OPERATION_Exception(10243, string);
            } else {
                return defActiveServer;
            }
        }
        LaunchRecord launchRecord = new LaunchRecord(string, string5, string4, string3, Config.get_IIOP_LISTEN_PORT(), Config.get_IIOP_LISTEN_PORT(), _CORBA.Orbix.myPid(), string2);
        defActiveServer = (DefActiveServer)this.loadNewServer(launchRecord, string, string5, string2, (String)var16_17);
        return defActiveServer;
    }

    protected ActiveServer loadNewServer(LaunchRecord launchRecord, String string, String string2, String string3, String string4) throws SystemException {
        if (!string4.startsWith("###ORBIXWEB###")) {
            throw new NO_IMPLEMENT(ErrorMsgs.getMessage(12806, ""), 12806, CompletionStatus.COMPLETED_NO);
        }
        LaunchArguments launchArguments = new LaunchArguments(string4);
        Class clazz = DefServerManager.findClass(launchArguments.getClassname(), launchArguments.getClasspath());
        String string5 = LaunchTable.getLaunchKey(string, "*", null);
        DefImplFinder.launchedServers.add(string5, launchRecord);
        try {
            ClassLauncher.invokeMethod(clazz, "main", launchArguments.getArgs(), true, launchRecord, DefImplFinder.launchedServers);
            launchRecord.waitOnServer();
        }
        catch (SystemException systemException) {
            DefImplFinder.launchedServers.remove(string5);
            throw systemException;
        }
        catch (Exception exception) {
            DefImplFinder.launchedServers.remove(string5);
            return null;
        }
        DefActiveServer defActiveServer = new DefActiveServer(string2, launchRecord.user_name, launchRecord);
        return defActiveServer;
    }

    private ActiveServer getActiveServer(String string, String string2, String string3) {
        String string4 = LaunchTable.getLaunchKey(string, "*", null);
        LaunchRecord launchRecord = DefImplFinder.launchedServers.get(string4);
        if (launchRecord != null) {
            return new DefActiveServer(string, launchRecord.user_name, launchRecord);
        }
        return null;
    }

    private String extractMarker(String[] stringArray) {
        if (stringArray.length == 0) {
            return "*";
        }
        return stringArray[0];
    }

    private String extractCommand(String[] stringArray) {
        return stringArray[0];
    }

    public static Class findClass(String string, String string2) throws SystemException {
        ClassLauncher classLauncher = new ClassLauncher(string2);
        try {
            Class clazz = classLauncher.loadClass(string);
            return clazz;
        }
        catch (Exception exception) {
            DJException.throw_BAD_PARAM_Exception(12808, string);
            return null;
        }
    }
}

