/*
 * Decompiled with CFR 0.152.
 */
package IE.Iona.OrbixWeb.Activator;

import IE.Iona.OrbixWeb.Activator.ActivationPolicy;
import IE.Iona.OrbixWeb.Activator.ActiveServer;
import IE.Iona.OrbixWeb.Activator.DJException;
import IE.Iona.OrbixWeb.Activator.DJNVList;
import IE.Iona.OrbixWeb.Activator.DefActiveServer;
import IE.Iona.OrbixWeb.Activator.DefServerManager;
import IE.Iona.OrbixWeb.Activator.ImplFinder;
import IE.Iona.OrbixWeb.Activator.LaunchRecord;
import IE.Iona.OrbixWeb.Activator.LaunchTable;
import IE.Iona.OrbixWeb.Activator.ProcessManager;
import IE.Iona.OrbixWeb.Activator.ServerEntry;
import IE.Iona.OrbixWeb.Activator.ServerEntryTable;
import IE.Iona.OrbixWeb.Activator.ServerManager;
import IE.Iona.OrbixWeb.CORBA.ErrorMsgs;
import IE.Iona.OrbixWeb.CORBA.NVList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.SystemException;

public class DefImplFinder
implements ImplFinder {
    public static LaunchTable launchedServers;
    private ServerEntryTable knownServers;
    private static final int COLON_POSITION = 15;
    private static final int IMP_REP_ENTRY_VERSIONNUM = 2;
    private static final String IMP_REP_ENTRY_COMM = "tcp";
    private static final String IMP_REP_ENTRY_CODE = "xdr";
    private static final String IMP_REP_NAME = "Name";
    private static final String IMP_REP_COMMS = "Comms";
    private static final String IMP_REP_ACTIVATION = "Activation";
    private static final String IMP_REP_OWNER = "Owner";
    private static final String IMP_REP_LAUNCH = "Launch";
    private static final String IMP_REP_INVOKE = "Invoke";
    private static final String IMP_REP_VERSION = "ImpRep Version";
    private static final String IMP_REP_NUMSERVERS = "no. of servers";
    private static final String IMP_REP_PORT = "server's port";
    private String implementationRepositoryPath;
    private static String classPath;
    private boolean inProcess = false;
    private boolean redirectProcess = false;

    public static LaunchTable getLaunchTable() {
        return launchedServers;
    }

    public ServerEntryTable getKnownServers() {
        return this.knownServers;
    }

    public DefImplFinder(String string, String string2, boolean bl, boolean bl2) {
        this.implementationRepositoryPath = string;
        classPath = string2;
        this.inProcess = bl;
        this.redirectProcess = bl2;
    }

    public void initialise() throws SystemException {
        launchedServers = new LaunchTable();
        this.knownServers = new ServerEntryTable();
        this.loadServersFromRepository();
    }

    public ServerManager create(String string, String string2, NVList nVList) throws SystemException {
        if (string != null) {
            throw new NO_IMPLEMENT(ErrorMsgs.getMessage(12809, ""), 12809, CompletionStatus.COMPLETED_NO);
        }
        if (string2 == null || nVList == null) {
            DJException.throw_BAD_PARAM_Exception(12021, "");
        }
        ServerManager serverManager = null;
        try {
            this.createImpRepFile(string, string2, nVList);
        }
        catch (Exception exception) {
            this.removeImpRepFile(string, string2);
            DJException.throw_BAD_OPERATION_Exception(10145, string2);
        }
        try {
            this.loadServerFromFile(this.filePath(string2));
            serverManager = this.find(string, string2);
        }
        catch (SystemException systemException) {
            this.removeImpRepFile(string, string2);
            throw systemException;
        }
        return serverManager;
    }

    public void delete(ServerManager serverManager) throws SystemException {
        if (serverManager == null) {
            DJException.throw_BAD_PARAM_Exception(12021, "");
        }
        String string = serverManager.name();
        String string2 = serverManager.context();
        if (string2 != null) {
            throw new NO_IMPLEMENT(12021, CompletionStatus.COMPLETED_NO);
        }
        this.removeImpRepFile(string2, string);
        this.knownServers.remove(string);
    }

    private void killServers(ActiveServer[] activeServerArray) {
        int n = 0;
        while (n < activeServerArray.length) {
            DefActiveServer defActiveServer = (DefActiveServer)activeServerArray[n];
            LaunchRecord launchRecord = defActiveServer.getLaunchRecord();
            if (launchRecord != null) {
                launchRecord.destroy();
                String string = launchRecord.getServerName();
                activeServerArray[n].marker();
                String string2 = LaunchTable.getLaunchKey(string, "*", null);
                launchedServers.remove(string2);
            }
            ++n;
        }
    }

    public ServerManager find(String string, String string2) throws SystemException {
        ServerEntry serverEntry;
        if (string2 == null) {
            DJException.throw_BAD_PARAM_Exception(12021, "");
        }
        if ((serverEntry = this.knownServers.get(string2)) == null) {
            DJException.throw_BAD_OPERATION_Exception(10241, string2);
        }
        return this.newServerManager(string2, serverEntry.details(), this);
    }

    public ServerManager[] findAll(String string) {
        if (string == null || string.equals("")) {
            string = null;
        }
        ServerManager[] serverManagerArray = this.getServersInDir(this.knownServers.elements(), string);
        return serverManagerArray;
    }

    private ServerManager[] getServersInDir(Enumeration enumeration, String string) {
        Vector<ServerEntry> vector = new Vector<ServerEntry>(5, 5);
        ServerEntry serverEntry = null;
        while (enumeration.hasMoreElements()) {
            serverEntry = (ServerEntry)enumeration.nextElement();
            if (!serverEntry.isInDir(string)) continue;
            vector.addElement(serverEntry);
        }
        Object[] objectArray = new ServerManager[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String getDefaultClasspath() {
        return classPath;
    }

    public ServerEntry updateMarker(String string, String string2, String string3) throws SystemException {
        ServerEntry serverEntry = this.knownServers.get(string);
        if (serverEntry == null) {
            DJException.throw_BAD_OPERATION_Exception(10241, string);
        }
        NVList nVList = serverEntry.details();
        String[] stringArray = null;
        String[] stringArray2 = null;
        try {
            stringArray = DJNVList.getStringArrayFromNVList(1, nVList);
            stringArray2 = DJNVList.getStringArrayFromNVList(2, nVList);
        }
        catch (Bounds bounds) {
            DJException.throw_BAD_PARAM_Exception(10146, bounds.toString());
        }
        int n = DefImplFinder.findIndexFor(string2, stringArray);
        if (n == -1) {
            String[] stringArray3 = new String[stringArray.length + 1];
            String[] stringArray4 = new String[stringArray2.length + 1];
            int n2 = 0;
            n2 = 0;
            while (n2 < stringArray.length) {
                stringArray3[n2] = stringArray[n2];
                stringArray4[n2] = stringArray2[n2];
                ++n2;
            }
            stringArray3[n2] = string2;
            stringArray4[n2] = string3;
            DJNVList.setValue(1, stringArray3, nVList);
            DJNVList.setValue(2, stringArray4, nVList);
        } else {
            stringArray[n] = string2;
            stringArray2[n] = string3;
        }
        return serverEntry;
    }

    public boolean newShared(String string, String string2, String[] stringArray, String[] stringArray2, int n, int n2, int n3) throws SystemException {
        Object object;
        if (!(string2.indexOf(58) == -1 && string2.indexOf(32) == -1 && !string2.equals(""))) {
            DJException.throw_BAD_PARAM_Exception(10032, string2);
        }
        int n4 = 0;
        while (n4 < stringArray.length) {
            object = stringArray[n4];
            if (!(((String)object).indexOf(58) == -1 && ((String)object).indexOf(32) == -1 && !((String)object).equals(""))) {
                DJException.throw_BAD_PARAM_Exception(10030, stringArray[n4]);
            }
            ++n4;
        }
        object = new DJNVList(12);
        String[] stringArray3 = new String[]{";"};
        String[] stringArray4 = new String[]{";"};
        ((DJNVList)object).add("NAME", string2);
        ((DJNVList)object).add("MARKERS", stringArray);
        ((DJNVList)object).add("COMMANDS", stringArray2);
        ((DJNVList)object).add("ACTIVATION", n);
        ((DJNVList)object).add("OWNER", string);
        ((DJNVList)object).add("LAUNCH", stringArray3);
        ((DJNVList)object).add("INVOKE", stringArray4);
        ((DJNVList)object).add("VERSION", 2);
        ((DJNVList)object).add("NUMSERVERS", n2);
        ((DJNVList)object).add("PORT", n3);
        ((DJNVList)object).add("COMMS", IMP_REP_ENTRY_COMM);
        ((DJNVList)object).add("CODE", IMP_REP_ENTRY_CODE);
        this.create(null, string2, (NVList)object);
        return true;
    }

    public static boolean validateServerName(String string) {
        return string.indexOf(58) == -1 && string.indexOf(32) == -1 && !string.equals("");
    }

    public static boolean validateMarker(String string) {
        return string.indexOf(58) == -1 && string.indexOf(32) == -1 && !string.equals("");
    }

    public static String rightsToString(String[] stringArray) {
        if (stringArray.length == 1 && stringArray[0].equals(";")) {
            return ";";
        }
        return DefImplFinder.joinString(stringArray, ';', true, true);
    }

    protected BufferedReader getImpRepStream(File file) throws SystemException {
        if (!file.exists()) {
            DJException.throw_BAD_OPERATION_Exception(10241, this.getServerName(file));
        }
        if (!file.canRead()) {
            DJException.throw_BAD_OPERATION_Exception(10158, file.getPath());
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            DJException.throw_BAD_OPERATION_Exception(10152, file.getPath());
        }
        return bufferedReader;
    }

    private String getServerName(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(".imp");
        if (n < 0) {
            n = string.lastIndexOf(".imp".toUpperCase());
        }
        try {
            return string.substring(0, n);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return null;
        }
    }

    private void loadServersFromRepository() throws SystemException {
        File file = null;
        try {
            file = new File(this.implementationRepositoryPath);
        }
        catch (NullPointerException nullPointerException) {
            DJException.throw_BAD_PARAM_Exception(12803, "");
        }
        if (!file.isDirectory()) {
            DJException.throw_BAD_OPERATION_Exception(10157, this.implementationRepositoryPath);
        }
        this.loadServersFromDir(file);
    }

    private void loadServersFromDir(File file) {
        Object object;
        if (!file.exists()) {
            return;
        }
        File[] fileArray = this.getFilesFromDir(file);
        int n = 0;
        while (n < fileArray.length) {
            object = fileArray[n];
            if (((File)object).getName().toLowerCase().endsWith(".imp")) {
                this.loadServerFromFile(fileArray[n]);
            }
            ++n;
        }
        object = this.getDirsFromDir(file);
        int n2 = 0;
        while (n2 < ((Object)object).length) {
            this.loadServersFromDir((File)object[n2]);
            ++n2;
        }
    }

    private synchronized void loadServerFromFile(File file) throws SystemException {
        Object object;
        Serializable serializable;
        BufferedReader bufferedReader = this.getImpRepStream(file);
        String string = this.readImpRepLine(bufferedReader);
        String string2 = this.readImpRepLine(bufferedReader);
        String string3 = this.readImpRepLine(bufferedReader);
        String string4 = this.readImpRepLine(bufferedReader);
        String string5 = this.readImpRepLine(bufferedReader);
        String string6 = this.readImpRepLine(bufferedReader);
        String string7 = this.extractImpRepParameter(string, IMP_REP_NAME);
        string7 = DefImplFinder.convertToNativePathFormat(string7);
        String string8 = this.extractImpRepParameter(string2, IMP_REP_COMMS);
        String string9 = string8.substring(string8.indexOf(47) + 1);
        String string10 = null;
        try {
            string10 = string8.substring(0, string8.indexOf(47));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.closeStream(bufferedReader);
            DJException.throw_BAD_PARAM_Exception(10142, string8);
        }
        String string11 = this.extractImpRepParameter(string3, IMP_REP_ACTIVATION);
        int n = ActivationPolicy.stringToActivationMode(string11);
        String string12 = this.extractImpRepParameter(string4, IMP_REP_OWNER);
        String string13 = this.extractImpRepParameter(string5, IMP_REP_LAUNCH);
        String string14 = this.extractImpRepParameter(string6, IMP_REP_INVOKE);
        String string15 = this.readImpRepLine(bufferedReader);
        int n2 = 0;
        long l = 1L;
        long l2 = 0L;
        if (string15 != null && string15.startsWith(IMP_REP_VERSION)) {
            string8 = this.extractImpRepParameter(string15, IMP_REP_VERSION);
            serializable = new Integer(string8);
            n2 = (Integer)serializable;
            object = this.readImpRepLine(bufferedReader);
            string8 = this.extractImpRepParameter((String)object, IMP_REP_NUMSERVERS);
            serializable = new Integer(string8);
            l = ((Integer)serializable).intValue();
            String string16 = this.readImpRepLine(bufferedReader);
            string8 = this.extractImpRepParameter(string16, IMP_REP_PORT);
            serializable = new Integer(string8);
            l2 = ((Integer)serializable).intValue();
        }
        serializable = new Vector(5, 5);
        object = new Vector(5, 5);
        int n3 = this.getMarkersAndCommands(string7, n2, bufferedReader, (Vector)serializable, (Vector)object);
        this.closeStream(bufferedReader);
        Object[] objectArray = new String[n3];
        Object[] objectArray2 = new String[n3];
        ((Vector)serializable).copyInto(objectArray);
        ((Vector)object).copyInto(objectArray2);
        String[] stringArray = null;
        String[] stringArray2 = null;
        stringArray = string13.equals(";") ? new String[]{";"} : DefImplFinder.splitString(string13, ";");
        stringArray2 = string14.equals(";") ? new String[]{";"} : DefImplFinder.splitString(string14, ";");
        ServerEntry serverEntry = new ServerEntry(string7);
        serverEntry.add("NAME", string7);
        serverEntry.add("MARKERS", (String[])objectArray);
        serverEntry.add("COMMANDS", (String[])objectArray2);
        serverEntry.add("ACTIVATION", n);
        serverEntry.add("OWNER", string12);
        serverEntry.add("LAUNCH", stringArray);
        serverEntry.add("INVOKE", stringArray2);
        serverEntry.add("VERSION", n2);
        serverEntry.add("NUMSERVERS", l);
        serverEntry.add("PORT", l2);
        serverEntry.add("COMMS", string9);
        serverEntry.add("CODE", string10);
        this.knownServers.add(string7, serverEntry);
    }

    private void closeStream(BufferedReader bufferedReader) {
        try {
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private File[] getFilesFromDir(File file) {
        Object object;
        String[] stringArray = file.list();
        Vector<Object> vector = new Vector<Object>(5, 5);
        int n = 0;
        while (n < stringArray.length) {
            object = new File(file, stringArray[n]);
            if (!((File)object).isDirectory()) {
                vector.addElement(object);
            }
            ++n;
        }
        object = new File[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private File[] getDirsFromDir(File file) {
        Object object;
        String[] stringArray = file.list();
        Vector<Object> vector = new Vector<Object>(5, 5);
        int n = 0;
        while (n < stringArray.length) {
            object = new File(file, stringArray[n]);
            if (((File)object).isDirectory()) {
                vector.addElement(object);
            }
            ++n;
        }
        object = new File[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private boolean isServerFile(File file) {
        return file.getName().toLowerCase().endsWith(".imp");
    }

    private int getMarkersAndCommands(String string, int n, BufferedReader bufferedReader, Vector vector, Vector vector2) throws SystemException {
        if (n != 0) {
            this.readImpRepLine(bufferedReader);
        }
        this.readImpRepLine(bufferedReader);
        this.readImpRepLine(bufferedReader);
        String string2 = this.readImpRepLine(bufferedReader);
        if (string2 == null) {
            DJException.throw_BAD_OPERATION_Exception(10151, this.filePath(string).getPath());
        }
        String string3 = null;
        String string4 = null;
        while (string2 != null) {
            string2 = string2.trim();
            try {
                string3 = string2.substring(0, string2.indexOf(32));
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                DJException.throw_BAD_PARAM_Exception(10151, this.filePath(string).getPath());
            }
            string4 = string2.substring(string2.indexOf(32)).trim();
            vector.addElement(string3);
            vector2.addElement(string4);
            string2 = this.readImpRepLine(bufferedReader);
        }
        return vector.size();
    }

    private File filePath(String string) {
        string = DefImplFinder.convertToNativePathFormat(string);
        File file = null;
        file = File.separatorChar == '\\' ? this.windowsFilePath(string) : this.unixFilePath(string);
        return file;
    }

    private File unixFilePath(String string) {
        File file = new File(this.implementationRepositoryPath, String.valueOf(string) + ".imp".toUpperCase());
        if (!file.exists()) {
            file = new File(this.implementationRepositoryPath, String.valueOf(string) + ".imp");
        }
        return file;
    }

    private File windowsFilePath(String string) {
        File file = new File(this.implementationRepositoryPath, String.valueOf(string) + ".imp");
        if (!file.exists()) {
            file = new File(this.implementationRepositoryPath, String.valueOf(string) + ".imp".toUpperCase());
        }
        return file;
    }

    private String extractImpRepParameter(String string, String string2) throws SystemException {
        if (string == null || string2 == null) {
            DJException.throw_BAD_PARAM_Exception(10142, "");
        }
        try {
            int n = string.indexOf(58);
            if (n == -1 || !string.startsWith(string2)) {
                DJException.throw_BAD_PARAM_Exception(10142, string);
            }
            return string.substring(n + 2).trim();
        }
        catch (Exception exception) {
            DJException.throw_BAD_PARAM_Exception(10142, string);
            return null;
        }
    }

    private String readImpRepLine(BufferedReader bufferedReader) throws SystemException {
        String string = null;
        try {
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            DJException.throw_BAD_PARAM_Exception(10151, "");
        }
        return string;
    }

    public static String joinString(String[] stringArray, char c, boolean bl, boolean bl2) {
        String string = "";
        int n = stringArray.length;
        while (n > 0) {
            if (bl && n == stringArray.length) {
                string = String.valueOf(string) + c;
            }
            string = String.valueOf(string) + stringArray[n - 1];
            if (bl2 && n == 1) {
                string = String.valueOf(string) + c;
            } else if (n > 1) {
                string = String.valueOf(string) + c;
            }
            --n;
        }
        return string;
    }

    public static String[] splitString(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                stringArray[n2] = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {}
            ++n2;
        }
        return stringArray;
    }

    public synchronized void createImpRepFile(String string, String string2, NVList nVList) throws Exception {
        BufferedWriter bufferedWriter = null;
        File file = this.filePath(string2);
        bufferedWriter = new BufferedWriter(new FileWriter(file));
        try {
            this.writeImpRepFile(file, bufferedWriter, string, string2, nVList);
        }
        catch (Exception exception) {
            bufferedWriter.close();
            throw exception;
        }
        bufferedWriter.close();
    }

    private void writeImpRepFile(File file, BufferedWriter bufferedWriter, String string, String string2, NVList nVList) throws IOException, Bounds {
        int n = 0;
        int n2 = n++;
        String string3 = nVList.item(n2).value().extract_string();
        String[] stringArray = DJNVList.getStringArrayFromNVList(n++, nVList);
        String[] stringArray2 = DJNVList.getStringArrayFromNVList(n++, nVList);
        int n3 = n++;
        n3 = nVList.item(n3).value().extract_long();
        int n4 = n++;
        String string4 = nVList.item(n4).value().extract_string();
        String[] stringArray3 = DJNVList.getStringArrayFromNVList(n++, nVList);
        String[] stringArray4 = DJNVList.getStringArrayFromNVList(n++, nVList);
        int n5 = n++;
        n5 = nVList.item(n5).value().extract_long();
        int n6 = n++;
        n6 = nVList.item(n6).value().extract_long();
        int n7 = n++;
        n7 = nVList.item(n7).value().extract_long();
        int n8 = n++;
        String string5 = nVList.item(n8).value().extract_string();
        int n9 = n++;
        String string6 = nVList.item(n9).value().extract_string();
        String string7 = stringArray3.length == 1 && stringArray3[0].equals(";") ? ";" : DefImplFinder.joinString(stringArray3, ';', true, true);
        String string8 = stringArray4.length == 1 && stringArray4[0].equals(";") ? ";" : DefImplFinder.joinString(stringArray4, ';', true, true);
        this.writeImpRepLine(file.getPath(), bufferedWriter, IMP_REP_NAME, string3);
        this.writeImpRepLine(file.getPath(), bufferedWriter, IMP_REP_COMMS, String.valueOf(string6) + "/" + string5);
        this.writeImpRepLine(file.getPath(), bufferedWriter, IMP_REP_ACTIVATION, ActivationPolicy.activationModeToString(n3));
        this.writeImpRepLine(file.getPath(), bufferedWriter, IMP_REP_OWNER, string4);
        this.writeImpRepLine(file.getPath(), bufferedWriter, IMP_REP_LAUNCH, string7);
        this.writeImpRepLine(file.getPath(), bufferedWriter, IMP_REP_INVOKE, string8);
        this.writeImpRepLine(file.getPath(), bufferedWriter, IMP_REP_VERSION, String.valueOf(n5));
        this.writeImpRepLine(file.getPath(), bufferedWriter, IMP_REP_NUMSERVERS, String.valueOf(n6));
        this.writeImpRepLine(file.getPath(), bufferedWriter, IMP_REP_PORT, String.valueOf(n7));
        bufferedWriter.newLine();
        this.writeImpRepMarkers(file.getPath(), bufferedWriter, stringArray, stringArray2);
    }

    private void writeImpRepMarkers(String string, BufferedWriter bufferedWriter, String[] stringArray, String[] stringArray2) throws IOException {
        String string2 = null;
        bufferedWriter.write("     Marker          Launch Command");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        int n = 0;
        while (n < stringArray.length) {
            string2 = this.rightPad(stringArray[n], 15, ' ');
            bufferedWriter.write("     " + string2 + " " + stringArray2[n]);
            bufferedWriter.newLine();
            ++n;
        }
    }

    private String rightPad(String string, int n, char c) {
        if (string.length() > n) {
            return string;
        }
        int n2 = n - string.length();
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = c;
            ++n3;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string);
        stringBuffer.append(cArray);
        return stringBuffer.toString();
    }

    private void writeImpRepLine(String string, BufferedWriter bufferedWriter, String string2, String string3) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(string2);
        while (stringBuffer.length() < 15) {
            stringBuffer = stringBuffer.append(' ');
        }
        stringBuffer = stringBuffer.append(": " + string3);
        bufferedWriter.write(stringBuffer.toString());
        bufferedWriter.newLine();
    }

    public synchronized void removeImpRepFile(String string, String string2) throws SystemException {
        File file = this.filePath(string2);
        if (file.exists()) {
            if (file.canWrite()) {
                file.delete();
                return;
            }
            DJException.throw_NO_PERMISSION_Exception(10156, string2);
        }
    }

    public static int findIndexFor(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private DefServerManager newServerManager(String string, NVList nVList, DefImplFinder defImplFinder) {
        if (this.inProcess) {
            return new DefServerManager(string, nVList, defImplFinder);
        }
        return new ProcessManager(string, nVList, defImplFinder, this.redirectProcess);
    }

    public static String convertToNativePathFormat(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.replace('/', File.separatorChar);
        String string3 = string2.replace('\\', File.separatorChar);
        return string3;
    }

    static {
        classPath = null;
    }
}

