/*
 * Decompiled with CFR 0.152.
 */
package IE.Iona.OrbixWeb.Activator;

import IE.Iona.OrbixWeb.Activator.AboutDialog;
import IE.Iona.OrbixWeb.Activator.Activator;
import IE.Iona.OrbixWeb.Activator.ClassLauncher;
import IE.Iona.OrbixWeb.Activator.Constants;
import IE.Iona.OrbixWeb.Activator.DJSecurityManager;
import IE.Iona.OrbixWeb.Activator.DefImplFinder;
import IE.Iona.OrbixWeb.Activator.GuiConsole;
import IE.Iona.OrbixWeb.Activator.ReallyQuitDialog;
import IE.Iona.OrbixWeb.CORBA.ORB;
import IE.Iona.OrbixWeb.Features.Config;
import IE.Iona.OrbixWeb._CORBA;
import java.awt.CheckboxMenuItem;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.net.URL;

public class DJGuiConsole
extends GuiConsole {
    private static final String DEBUGMENU = "Diagnostics";
    private static final String DEBUGLOW = "Low";
    private static final String DEBUGMEDIUM = "Medium";
    private static final String DEBUGHIGH = "High";
    private static final String HELPMENU = "Help";
    private static final String HELPABOUT = "About";
    private CheckboxMenuItem debuglow;
    private CheckboxMenuItem debugmedium;
    private CheckboxMenuItem debughigh;
    private Activator activator;

    public DJGuiConsole(Activator activator, String string) {
        super(string);
        MenuBar menuBar = this.getMenu();
        Menu menu = null;
        Menu menu2 = null;
        menu = new Menu(DEBUGMENU);
        menu.setFont(new Font("sanserif", 0, 12));
        this.debuglow = new CheckboxMenuItem(DEBUGLOW, true);
        this.debugmedium = new CheckboxMenuItem(DEBUGMEDIUM);
        this.debughigh = new CheckboxMenuItem(DEBUGHIGH);
        menu.add(this.debuglow);
        menu.add(this.debugmedium);
        menu.add(this.debughigh);
        menuBar.add(menu);
        menu2 = new Menu(HELPMENU);
        menu2.setFont(new Font("sanserif", 0, 12));
        menu2.add(new MenuItem(HELPABOUT));
        menuBar.add(menu2);
        try {
            String string2 = ClassLauncher.searchClassPath("orbixdj.gif");
            if (string2 != null) {
                URL uRL = new URL("file:" + string2);
                Image image = this.getToolkit().getImage(uRL);
                this.setIconImage(image);
            }
        }
        catch (Exception exception) {}
        this.setInitialDiagnosticLevel();
        this.activator = activator;
        this.pack();
        this.show();
    }

    public static Font createSystemFont(int n) {
        return new Font("sanserif", 0, n);
    }

    public boolean handleEvent(Event event) {
        if (event.target instanceof CheckboxMenuItem) {
            if (event.target == this.debuglow) {
                this.setDebugLevel(0);
                this.setDebugMenu(0);
                return true;
            }
            if (event.target == this.debugmedium) {
                this.setDebugLevel(1);
                this.setDebugMenu(1);
                return true;
            }
            if (event.target == this.debughigh) {
                this.setDebugLevel(2);
                this.setDebugMenu(2);
                return true;
            }
        } else if (event.target instanceof MenuItem && ((String)event.arg).equals(HELPABOUT)) {
            this.showAboutBox();
            return true;
        }
        return super.handleEvent(event);
    }

    private void showAboutBox() {
        AboutDialog aboutDialog = new AboutDialog((Frame)this, false);
        aboutDialog.show();
    }

    private void setDebugLevel(int n) {
        ORB.setDiagnostics(n);
        if (n == 0) {
            System.out.println("Setting diagnostic output to low.");
            return;
        }
        if (n == 1) {
            System.out.println("Setting diagnostic output to medium.");
            return;
        }
        if (n == 2) {
            System.out.println("Setting diagnostic output to high.");
        }
    }

    protected void die() {
        DefImplFinder defImplFinder = null;
        defImplFinder = (DefImplFinder)this.activator.finder();
        if (DefImplFinder.launchedServers.size() != 0) {
            new ReallyQuitDialog((Frame)this, "Really quit?", "There are active servers - do you really want to exit?");
            return;
        }
        _CORBA.Orbix.finalize();
        if (System.getSecurityManager() != null) {
            DJSecurityManager dJSecurityManager = null;
            dJSecurityManager = (DJSecurityManager)System.getSecurityManager();
            dJSecurityManager.allowExit();
        }
        System.exit(0);
    }

    private final void setInitialDiagnosticLevel() {
        String string = Config.getConfigItem("setDiagnostics");
        int n = Constants.toInt(string);
        ORB.setDiagnostics(n);
        this.setDebugMenu(n);
    }

    private final void setDebugMenu(int n) {
        this.debuglow.setState(false);
        this.debugmedium.setState(false);
        this.debughigh.setState(false);
        switch (n) {
            case 0: {
                this.debuglow.setState(true);
                return;
            }
            case 1: {
                this.debugmedium.setState(true);
                return;
            }
        }
        this.debughigh.setState(true);
    }
}

