/*
 * Decompiled with CFR 0.152.
 */
package IE.Iona.OrbixWeb.Activator;

import IE.Iona.OrbixWeb.Activator.StringVector;
import java.util.Enumeration;
import java.util.Vector;

public class Argument {
    protected String argumentToken;
    protected String argumentValue;
    protected boolean required;
    protected Vector possibleValues = new Vector();
    protected StringVector alternateNames = new StringVector(1, 1);

    public Argument(String string, String string2, boolean bl) {
        this.argumentToken = string;
        this.required = bl;
        this.argumentValue = string2;
    }

    public Argument(String string, boolean bl) {
        this.argumentToken = string;
        this.required = bl;
        this.argumentValue = null;
    }

    public Argument(String string) {
        this.argumentToken = string;
        this.required = true;
        this.argumentValue = null;
    }

    public void addPossibleValue(String string) {
        this.possibleValues.addElement(string);
    }

    public void addAlternateName(String string) {
        this.alternateNames.addElement(string);
    }

    public String token() {
        return this.argumentToken;
    }

    public String value() {
        return this.argumentValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void required() {
        this.required = true;
    }

    public void notRequired() {
        this.required = false;
    }

    public boolean parseArgument(StringVector stringVector) {
        boolean bl = false;
        int n = 0;
        while (n < stringVector.size()) {
            if (this.isArgument(stringVector.getElementAt(n))) {
                if (n + 1 < stringVector.size()) {
                    this.argumentValue = stringVector.getElementAt(n + 1);
                    stringVector.removeElementAt(n + 1);
                    bl = true;
                }
                stringVector.removeElementAt(n);
            }
            ++n;
        }
        if (!this.isAllowedValue(this.argumentValue)) {
            return false;
        }
        return !this.required || bl;
    }

    protected boolean isArgument(String string) {
        if (string.equals(this.argumentToken)) {
            return true;
        }
        if (this.alternateNames.size() > 0) {
            return this.isArgumentFromAlternatives(string);
        }
        return false;
    }

    private boolean isArgumentFromAlternatives(String string) {
        int n = 0;
        while (n < this.alternateNames.size()) {
            if (this.alternateNames.getElementAt(n).equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isAllowedValue(String string) {
        if (this.possibleValues.size() == 0) {
            return true;
        }
        Enumeration enumeration = this.possibleValues.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public void printUsage() {
        System.out.print(" ");
        if (!this.required) {
            System.out.print("[");
        }
        if (this.possibleValues.size() != 0) {
            this.printPossibleValues();
        } else {
            this.printArgumentNames();
            System.out.print(" value");
        }
        if (!this.required) {
            System.out.print("]");
        }
    }

    private void printPossibleValues() {
        this.printArgumentNames();
        System.out.print(" ");
        Enumeration enumeration = this.possibleValues.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.print(string);
            if (!enumeration.hasMoreElements()) continue;
            System.out.print("|");
        }
    }

    protected void printArgumentNames() {
        System.out.print(this.argumentToken);
        if (this.alternateNames.size() > 0) {
            int n = 0;
            while (n < this.alternateNames.size()) {
                System.out.print("|" + this.alternateNames.getElementAt(n));
                ++n;
            }
        }
    }
}

