#include <iostream.h>
#include <fstream.h>
#include <stdio.h>
#include <string>
#include "playback_writer.h"
#include <time.h>
#include "..\..\datatypes\fieldObjects.h"
#include "..\..\datatypes\ai.h"


PlaybackLogger::PlaybackLogger(int team)
{
  thisTeam = team;
  //-------------------------------  
  //Get actual system time and date
  //-------------------------------  
  struct tm *newtime;
  time_t aclock;
  time( &aclock );                   //get time in seconds
  newtime = localtime( &aclock );    //convert to tm form 
  //------------------------------   
  //Get the year as a 4-digit #
  //------------------------------   
  int year = newtime->tm_year + 1900;
  //------------------------------   
  //Get the month as a 2-digit #
  //------------------------------   
  int mn = newtime->tm_mon + 1;
  char month[3];
  if(mn < 10)
    sprintf(month, "%c%d", '0', mn);
  else
    sprintf(month, "%d", mn);
  //------------------------------   
  //Get the day as a 2-digit #
  //------------------------------   
  int dy = newtime->tm_mday;
  char day[3];
  if(dy < 10)
    sprintf(day, "%c%d", '0', dy);    
  else
    sprintf(day, "%d", dy);
  //------------------------------   
  //Get the hour as a 2-digit #
  //------------------------------   
  int hr = newtime->tm_hour;
  char hour[3];
  if(hr < 10)
    sprintf(hour, "%c%d", '0', hr);    
  else
    sprintf(hour, "%d", hr);
  //------------------------------   
  //Get the minute as a 2-digit #
  //------------------------------   
  int mi = newtime->tm_min;
  char minute[3];
  if(mi < 10)
    sprintf(minute, "%c%d", '0', mi);    
  else
    sprintf(minute, "%d", mi);
  //------------------------------   
  //Get the second as a 2-digit #
  //------------------------------   
  int se = newtime->tm_sec;
  char second[3];
  if(se < 10)
    sprintf(second, "%c%d", '0', se);    
  else
    sprintf(second, "%d", se);
  //------------------------------   
  //A filename might look like this:
  //RoboCup_Log_Data_2001_04_07_at_05:23:17.txt
  //If you count it, there are always 43 characters in the filename

  sprintf(fileName, "playback_log_%d_%s_%s_at_%s_%s_%s.brml",
          year,
          month,
          day,
          hour,
          minute,
          second);    

  
  //======================================================
  //attempt to create the file based on the filename provided
  //if unsuccessful, bail out
  playbackSequence = fopen(fileName,"w");
  if (playbackSequence == NULL)
  {
    printf("Error creating playback sequence file :( \n");
    return;
  }
  //======================================================
  fprintf(playbackSequence, "<brml>\n");
  //======================================================
  //write friendly message at the top that tells the user 
  //how to get the spec of brml =-)
  fprintf(playbackSequence, "###############################\n");
  fprintf(playbackSequence, "# This is a playback sequence #\n");
  fprintf(playbackSequence, "# Specification: <!-- <brml> --> #\n");
  fprintf(playbackSequence, "# (Big Red Markup Language)   #\n");
  fprintf(playbackSequence, "#-----------------------------#\n");
  fprintf(playbackSequence, "# RoboCup Log Data:           #\n");
  fprintf(playbackSequence, "# %s/%s/%d at %s:%s:%s      #\n", 
                            month, day, year, hour, minute, second);
  fprintf(playbackSequence, "#-----------------------------#\n");
  fprintf(playbackSequence, "# Please see specification at #\n");
  fprintf(playbackSequence, "# end of file.                #\n");
  fprintf(playbackSequence, "#    -Your Friendly Big Red   #\n");
  fprintf(playbackSequence, "#     RoboCup AI Members...   #\n");
  fprintf(playbackSequence, "###############################\n");
  //======================================================
  //file open, write header of file with specification for
  //the sequence

  fprintf(playbackSequence, "################################\n");
  fprintf(playbackSequence, "# Generated by VisionTimer.exe #\n");
  fprintf(playbackSequence, "################################\n\n");
  //======================================================
  fprintf(playbackSequence, " <specification numberFrames='");
  fprintf(playbackSequence, "%i", 0);
  fprintf(playbackSequence, "' frameRate='");
  fprintf(playbackSequence, "%2.2f", 0.0f);
  fprintf(playbackSequence, "' robotsOnTeam0='");
  fprintf(playbackSequence, "%i", 5);
  fprintf(playbackSequence, "' robotsOnTeam1='");
  fprintf(playbackSequence, "%i", 5);
  fprintf(playbackSequence, "' ballsOnTeam0='");
  if(team == 0)
    fprintf(playbackSequence, "%i", 1);
  else
    fprintf(playbackSequence, "%i", 0);

  fprintf(playbackSequence, "' ballsOnTeam1='");
  if(team == 1)
	  fprintf(playbackSequence, "%i", 1);
  else
	  fprintf(playbackSequence, "%i", 0);

  fprintf(playbackSequence, "' thisTeam='");
  fprintf(playbackSequence, "%i", team);
  fprintf(playbackSequence, "'/>\n");
}

void PlaybackLogger::addFrame(const FieldData& vision, int frame)
{
  //beginning of frame
  fprintf(playbackSequence, "########################\n");
  fprintf(playbackSequence, " <frame number='");
  fprintf(playbackSequence, "%i", frame);
  fprintf(playbackSequence, "'>\n");

  for(int teamNumber=0; teamNumber <= 1; teamNumber++)
  {
    for(RobotIndex robot=ROBOT0; robot<NUM_ROBOTS; robot++)
    {
      fprintf(playbackSequence, "  <robot team='");       
      fprintf(playbackSequence, "%i", teamNumber);
      fprintf(playbackSequence, "' id='");
      fprintf(playbackSequence, "%i", robot);
      fprintf(playbackSequence, "' x='");
      fprintf(playbackSequence, "%1.3f", vision.team[teamNumber][robot].XPos);
      fprintf(playbackSequence, "' y='");
      fprintf(playbackSequence, "%1.3f", vision.team[teamNumber][robot].YPos);
      fprintf(playbackSequence, "' rot='");
      fprintf(playbackSequence, "%1.3f", vision.team[teamNumber][robot].Rotation);
      fprintf(playbackSequence, "' xVel='");
      fprintf(playbackSequence, "%1.3f", vision.team[teamNumber][robot].XVel);
      fprintf(playbackSequence, "' yVel='");
      fprintf(playbackSequence, "%1.3f", vision.team[teamNumber][robot].YVel);
      fprintf(playbackSequence, "' found='");
      fprintf(playbackSequence, "%i", vision.robotsFound[teamNumber][robot]);
      fprintf(playbackSequence, "'/>\n");
    }
  }
  
  //our one pathetic lonely robocup ball
  fprintf(playbackSequence, "  #----BALL DATA----\n");
  fprintf(playbackSequence, "  <ball id='0' team='%i' x='", thisTeam); 
  fprintf(playbackSequence, "%1.3f", vision.ball[0][0].XPos);
  fprintf(playbackSequence, "' y='"); 
  fprintf(playbackSequence, "%1.3f", vision.ball[0][0].YPos);
  fprintf(playbackSequence, "' xVel='"); 
  fprintf(playbackSequence, "%1.3f", vision.ball[0][0].XVel);
  fprintf(playbackSequence, "' yVel='"); 
  fprintf(playbackSequence, "%1.3f", vision.ball[0][0].YVel);
  fprintf(playbackSequence, "' found='");     
  fprintf(playbackSequence, "%i", vision.ballsFound[0][0]);
  fprintf(playbackSequence, "'/>\n");

  //end the frame
  fprintf(playbackSequence, " </frame>\n");
}

PlaybackLogger::~PlaybackLogger()
{

  //after all the frames put one last frame delimeter
  fprintf(playbackSequence, "########################\n");
  //======================================================
  //write the spec for brml
  fprintf(playbackSequence, "################################\n");
  fprintf(playbackSequence, "# BRML is easy. Put a # sign   #\n");
  fprintf(playbackSequence, "# at the beginning of a line,  #\n");
  fprintf(playbackSequence, "# and all characters after it  #\n");
  fprintf(playbackSequence, "# are ignored. Just make sure  #\n");
  fprintf(playbackSequence, "# # is the first character :)  #\n");
  fprintf(playbackSequence, "#                              #\n");
  fprintf(playbackSequence, "# When making a tag, write all #\n");
  fprintf(playbackSequence, "# flags on the same line!      #\n");
  fprintf(playbackSequence, "#                              #\n");
  fprintf(playbackSequence, "# BRML is actually written for #\n");
  fprintf(playbackSequence, "# you, so this should be good  #\n");
  fprintf(playbackSequence, "# enough for now. =-)          #\n");
  fprintf(playbackSequence, "################################\n");
  //======================================================
  //write end of file, closing the playbacksequence
  fprintf(playbackSequence, "</brml>\n");
      
  //close file :)
  fclose(playbackSequence);
  //======================================================

  printf("Playback sequence saved to file %s \n", fileName);

}
