#include "texture.h"
#include "Tga.h"

#include "TGALoader.h"

Texture::Texture() {
	strcpy(filename, "");
}

Texture::Texture(char *fn) {
	strcpy(filename, fn);
	init();
}

void Texture::init() {
	LoadTGA(this, filename);
	
	glGenTextures(1, &texID);
	glBindTexture(GL_TEXTURE_2D, texID);
	glTexImage2D(GL_TEXTURE_2D, 0, type, width, height, 0, type, GL_UNSIGNED_BYTE, imageData);

	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
}

void Texture::init(char *fn) {
	//filename = fn;
	strcpy(filename, fn);
	init();
}

Texture::Texture(int w, int h, int bpp) {
	width = w;
	height = h;
	bpp = bpp;
	
	imageData = (GLubyte *)malloc(w * h * bpp);
	datasize = w * h * bpp;

	if(bpp == 24) {
		type = GL_RGB;
	}
	else {
		type = GL_RGBA;
	}

	this->w = w;
	this->h = h;
	bypp = bpp / 8;
}

void Texture::createTexture() {
	glGenTextures(1, &texID);
	glBindTexture(GL_TEXTURE_2D, texID);
	glTexImage2D(GL_TEXTURE_2D, 0, type, width, height, 0, type, GL_UNSIGNED_BYTE, imageData);

	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
}

Color Texture::getPixel(int x, int y) {
	Color rv;
	int start;

	start = y * w * bypp + x * bypp;

	rv.r = imageData[start];
	rv.g = imageData[start+1];
	rv.b = imageData[start+2];
	if(bypp == 4)
		rv.a = imageData[start+3];
	else
		rv.a = 255;
	//rv = bmp->imageData[start] * 1000000 + bmp->imageData[start + 1] * 1000 + bmp->imageData[start + 2];
	return rv;
}

void Texture::save(FILE *output) {
	char buf[256];
	strcpy(buf, filename);
	fwrite(&(buf), sizeof(char), 256, output);
}

void Texture::load(FILE *input) {
	char buf[256];
	fread(&(buf), sizeof(char), 256, input);
	strcpy(filename, buf);

	LoadTGA(this, filename);
	
	glGenTextures(1, &texID);
	glBindTexture(GL_TEXTURE_2D, texID);
	glTexImage2D(GL_TEXTURE_2D, 0, type, width, height, 0, type, GL_UNSIGNED_BYTE, imageData);

	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
}