#include "system.h"

using namespace std;

System::System(Roster *roster, float width, float height, float gravity, float rcontainerw, float rcontainerh) {
	int i, j;

	this->width = width;
	this->height = height;
	this->gravity = gravity;
	this->rcontainerw = rcontainerw;
	this->rcontainerh = rcontainerh;
	this->roster = roster;
	highest_rigidity = 0;

	frame = 1;
	tick = 1;

	for(i = 0; i < MAXATOMS; i++) {
		for(j = 0; j < MAXATOMS; j++) {
			interacttable.set(i * MAXATOMS + j, (j < i));
		}
	}

	for(i = 0; i < MAXATOMS; i++) {
		atom_indices.set(i, false);
	}
}

void System::resize(int w, int h) {
	width = w;
	height = h;
}

Atom *System::addAtom(Atom *a) {
	int i;

	i = 0;
	while(atom_indices.test(i)) i++;
	a->index = i;
	a->system = this;
	
	if(a->x < 0) a->x = 0.0f;
	if(a->x > width) a->x = width;
	if(a->y < 0) a->y = 0.0f;
	if(a->y > height) a->y = height;

	a->object = NULL;
	atom_indices.set(i, true);
	a->updateContainer();

	interacttable.set(a->index * MAXATOMS + a->index, false);

	if(a->rigidity > highest_rigidity) highest_rigidity = a->rigidity;

	return a;
}

Link *System::addLink(Link *l) {

	interacttable.set(l->a->index * MAXATOMS + l->b->index, false);
	interacttable.set(l->b->index * MAXATOMS + l->a->index, false);
	//l->a->links.add(l);

	return l;
}

void System::removeAtom(Atom *a) {
	Link *l;
	roster->links.begin();
	while(l = roster->links.get())
		if(l->a == a || l->b == a)
			delete l;

	//atoms.remove(a);
	atom_indices.set(a->index, false);
}

void System::removeLink(Link *l) {
	///*
	if(l->reset_interactions) {
		if(l->b->index < l->a->index) {
			interacttable.set(l->a->index * MAXATOMS + l->b->index, true);
		}
		else {
			interacttable.set(l->b->index * MAXATOMS + l->a->index, true);
		}
	}
	//*/

	//links.remove(l);
}

void System::update() {
	int k;
	Atom *a;
	Link *l;

	frame++;

	tick++;

	roster->atoms.begin();
	while(a = roster->atoms.get())
		a->updateContainer();

	for(k = 0; k < highest_rigidity; k++) {
		roster->atoms.begin();
		while((a = roster->atoms.get()) && k < a->rigidity)
			a->repel();

		tick++;

		roster->atoms.begin();
		while(a = roster->atoms.get())
			a->snap();

		roster->links.begin();
		while((l = roster->links.get()) && k < l->rigidity)
			l->update();

		tick++;

		roster->atoms.begin();
		while(a = roster->atoms.get())
			a->snap();
	}

	tick++;

	roster->atoms.begin();
	while(a = roster->atoms.get())
		a->update();
}
