#include "staticobject.h"

StaticObject::StaticObject(Object *parent, RepulseField *rf, Texture *tex) : Object(parent) {
	parent->addStaticObject(this);
	this->rf = rf;
	this->tex = tex;
}

void StaticObject::atomFunc(Atom *a) {
	rf->apply(a);
}

void StaticObject::draw() {
	Object::draw();

	glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
	glBindTexture(GL_TEXTURE_2D, tex->texID);

	glEnable(GL_TEXTURE_2D);
	glBegin(GL_QUADS);
		glTexCoord2f(0.0f, 0.0f);	glVertex3f(rf->x, rf->y, 0.0f);
		glTexCoord2f(1.0f, 0.0f);	glVertex3f(rf->x + tex->width, rf->y, 0.0f);
		glTexCoord2f(1.0f, 1.0f);	glVertex3f(rf->x + tex->width, rf->y + tex->height, 0.0f);
		glTexCoord2f(0.0f, 1.0f);	glVertex3f(rf->x, rf->y + tex->height, 0.0f);
	glEnd();
	glDisable(GL_TEXTURE_2D);
}