#include "roster.h"
#include <stdio.h>

Roster::Roster(Object *parent) : Object(parent) {
	removed_atoms = 0;
	removed_links = 0;
	removed_polys = 0;
}

void Roster::addAtom(Atom *a)
{
	Object::addAtom(a);
	atoms.add(a);
}

void Roster::addLink(Link *l)
{
	Object::addLink(l);
	links.add(l);
}

void Roster::addPoly(Poly *p)
{
	Object::addPoly(p);
	polys.add(p);
}

Texture *Roster::addTexture(Texture *t)
{
	textures.add(t);
	return Object::addTexture(t);
}

void Roster::removeAtom(Atom *a) {
	Object::removeAtom(a);
	atoms.remove(a);
}

void Roster::removeLink(Link *l) {
	Object::removeLink(l);
	links.remove(l);
}

void Roster::removePoly(Poly *p) {
	Object::removePoly(p);
	polys.remove(p);
}

void Roster::estimateCenter() {
	if(polys.length() > 0) {
		cx = polys.head.next->datum->a1->x;
		cy = polys.head.next->datum->a1->y;
	}
	else {
		cx = 0;
		cy = 0;
	}
}

void Roster::calculateCenter() {
	if(atoms.length() == 0) return;
	cx = cy = 0;
	Atom *a;
	atoms.begin();
	while(a = atoms.get()) {
		cx += a->x;
		cy += a->y;
	}
	float mult = 1.0f / atoms.length();
	cx *= mult;
	cy *= mult;
}

void Roster::applyForce(float fx, float fy) {
	Atom *a;
	atoms.begin();
	while(a = atoms.get()) {
		a->fx += fx;
		a->fy += fy;
	}
}

void Roster::applyRotation(float speed) {
	Atom *a;
	float cx = 0, cy = 0;
	float div;
	int num = 0;

	atoms.begin();
	while(a = atoms.get()) {
		cx += a->x;
		cy += a->y;
		num++;
		a->mk = 0.0f;
	}

	div = 1.0f / num;
	cx *= div;
	cy *= div;

	atoms.begin();
	while(a = atoms.get()) {
		a->fx += speed * (a->y - cy);
		a->fy += speed * (cx - a->x);
	}
}

void Roster::clear()
{
	Atom *a;
	Link *l;
	Poly *p;

	atoms.begin();
	while(a = atoms.get())
		delete a;

	links.begin();
	while(l = links.get())
		delete l;

	polys.begin();
	while(p = polys.get())
		delete p;
}

Link *Roster::findLink(Atom *a, Atom *b) {
	Link *l;

	links.begin();
	while(l = links.get())
		if((l->a == a && l->b == b) || (l->a == b && l->b == a))
			return l;

	return NULL;
}

void Roster::save(const char *fn)
{
	FILE *output = fopen(fn, "w+b");
	save(output);
	fclose(output);
}

void Roster::save(FILE *output)
{
	int tmp;

	tmp = atoms.length();
	fwrite(&(tmp), sizeof(int), 1, output);

	Atom *a;
	atoms.begin();
	while(a = atoms.get())
		a->save(output);

	tmp = links.length();
	fwrite(&(tmp), sizeof(int), 1, output);

	Link *l;
	links.begin();
	while(l = links.get())
		l->save(output);	

	tmp = textures.length();
	fwrite(&(tmp), sizeof(int), 1, output);

	Texture *t;
	textures.begin();
	while(t = textures.get())
		t->save(output);

	tmp = polys.length();
	fwrite(&(tmp), sizeof(int), 1, output);

	Poly *p;
	polys.begin();
	while(p = polys.get())
		p->save(output);
}