#include "repulsefield.h"

RepulseField::RepulseField() {
	xo = NULL;
	yo = NULL;
	width = 0;
	height = 0;
}

RepulseField::RepulseField(int width, int height) {
	int i;

	this->width = width;
	this->height = height;
	xo = new int *[width];
	for(i = 0; i < width; i++) {
		xo[i] = new int[height];
	}
	yo = new int *[width];
	for(i = 0; i < width; i++) {
		yo[i] = new int[height];
	}
}

RepulseField::RepulseField(const char *fn, int xp, int yp) {
	xo = NULL;
	yo = NULL;

	this->x = xp;
	this->y = yp;

	load(fn);
}

RepulseField::RepulseField(FILE *file, int xp, int yp) {
	xo = NULL;
	yo = NULL;

	this->x = xp;
	this->y = yp;

	load(file);
}

RepulseField::~RepulseField() {
	int i;

	if(xo) {
		for(i = 0; i < width; i++) {
			delete xo[i];
		}
		delete xo;
	}
	if(yo) {
		for(i = 0; i < width; i++) {
			delete yo[i];
		}
		delete yo;
	}
}

void RepulseField::apply(Atom *a) {
	ax = a->x - x;
	ay = a->y - y;
	if(ax >= 0 && ax < width && ay >= 0 && ay < height) {
		a->x += xo[ax][ay];
		a->y += yo[ax][ay];
	}
}

void RepulseField::save(const char *fn) {
	FILE *output = fopen(fn, "w+b");
	save(output);
	fclose(output);
}

void RepulseField::save(FILE *output) {	
	int i;

	fwrite(&(width), sizeof(int), 1, output);
	fwrite(&(height), sizeof(int), 1, output);
	for(i = 0; i < width; i++) {
		fwrite(&(xo[i]), sizeof(int), height, output);
	}
	for(i = 0; i < width; i++) {
		fwrite(&(yo[i]), sizeof(int), height, output);
	}
}

void RepulseField::load(const char *fn) {
	FILE *input = fopen(fn, "rb");
	load(input);
	fclose(input);
}

void RepulseField::load(FILE *input) {	
	int i, j;

	fread(&(width), sizeof(int), 1, input);
	fread(&(height), sizeof(int), 1, input);

	if(!xo) {		
		xo = new int *[width];
		for(i = 0; i < width; i++) {
			xo[i] = new int[height];
		}
	}
	if(!yo) {
		yo = new int *[width];
		for(i = 0; i < width; i++) {
			yo[i] = new int[height];
		}
	}

	for(i = 0; i < width; i++) {
		for(j = 0; j < height; j++) {
			fread(&(xo[i][j]), sizeof(int), 1, input);
		}
	}
	for(i = 0; i < width; i++) {
		for(j = 0; j < height; j++) {
			fread(&(yo[i][j]), sizeof(int), 1, input);
		}
	}
}