#include "poly.h"

Poly::Poly() {
	init();
}

Poly::Poly(Atom *a, Atom *b, Atom *c) {
	init();
	a1 = a;
	a2 = b;
	a3 = c;
	x1 = &(a1->x);
	y1 = &(a1->y);
	x2 = &(a3->x);
	y2 = &(a3->y);
	x3 = &(a2->x);
	y3 = &(a2->y);
}

Poly::~Poly() {
	being_deleted = true;
	l1->removePoly(this);
	l2->removePoly(this);
	l3->removePoly(this);
	object->removePoly(this);
}

void Poly::init() {
	draw = true;
	a1 = a2 = a3 = NULL;
	x1 = x2 = x3 = NULL;
	y1 = y2 = y3 = NULL;
	l1 = l2 = l3 = NULL;
	tx1 = tx2 = tx3 = NULL;
	ty1 = ty2 = ty3 = NULL;
	object = NULL;
	being_deleted = false;
}

bool Poly::in(Object *o) {
	return (o && (object == o || in(o->parent)));
}

void Poly::setTexCoords() {
	rtx1 = float(tx1) / texture->width;
	rty1 = float(ty1) / texture->height;
	rtx2 = float(tx2) / texture->width;
	rty2 = float(ty2) / texture->height;
	rtx3 = float(tx3) / texture->width;
	rty3 = float(ty3) / texture->height;
}

void Poly::save(FILE *output) {
	fwrite(&(a1->x), sizeof(float), 1, output);
	fwrite(&(a1->y), sizeof(float), 1, output);
	fwrite(&(a2->x), sizeof(float), 1, output);
	fwrite(&(a2->y), sizeof(float), 1, output);
	fwrite(&(a3->x), sizeof(float), 1, output);
	fwrite(&(a3->y), sizeof(float), 1, output);
	fwrite(&(tx1), sizeof(float), 1, output);
	fwrite(&(ty1), sizeof(float), 1, output);
	fwrite(&(tx2), sizeof(float), 1, output);
	fwrite(&(ty2), sizeof(float), 1, output);
	fwrite(&(tx3), sizeof(float), 1, output);
	fwrite(&(ty3), sizeof(float), 1, output);
	fwrite(&(rtx1), sizeof(float), 1, output);
	fwrite(&(rty1), sizeof(float), 1, output);
	fwrite(&(rtx2), sizeof(float), 1, output);
	fwrite(&(rty2), sizeof(float), 1, output);
	fwrite(&(rtx3), sizeof(float), 1, output);
	fwrite(&(rty3), sizeof(float), 1, output);

	char texname[256];
	strcpy(texname, texture->filename);
	fwrite(&(texname), sizeof(char), 256, output);
}

void Poly::load(FILE *input, PhysList<Atom> atoms, PhysList<Texture> textures, float offx, float offy) {
	float a1x, a1y, a2x, a2y, a3x, a3y;
	Atom *a;
	Texture *t;
	char texname[256];

	fread(&(a1x), sizeof(float), 1, input);
	fread(&(a1y), sizeof(float), 1, input);
	fread(&(a2x), sizeof(float), 1, input);
	fread(&(a2y), sizeof(float), 1, input);
	fread(&(a3x), sizeof(float), 1, input);
	fread(&(a3y), sizeof(float), 1, input);
	a1x += offx;
	a1y += offy;
	a2x += offx;
	a2y += offy;
	a3x += offx;
	a3y += offy;

	atoms.begin();
	while(a = atoms.get()) {
		if(a->x == a1x && a->y == a1y)
			a1 = a;
		if(a->x == a2x && a->y == a2y)
			a2 = a;
		if(a->x == a3x && a->y == a3y)
			a3 = a;
	}

	x1 = &(a1->x);
	y1 = &(a1->y);
	x2 = &(a2->x);
	y2 = &(a2->y);
	x3 = &(a3->x);
	y3 = &(a3->y);

	fread(&(tx1), sizeof(float), 1, input);
	fread(&(ty1), sizeof(float), 1, input);
	fread(&(tx2), sizeof(float), 1, input);
	fread(&(ty2), sizeof(float), 1, input);
	fread(&(tx3), sizeof(float), 1, input);
	fread(&(ty3), sizeof(float), 1, input);
	fread(&(rtx1), sizeof(float), 1, input);
	fread(&(rty1), sizeof(float), 1, input);
	fread(&(rtx2), sizeof(float), 1, input);
	fread(&(rty2), sizeof(float), 1, input);
	fread(&(rtx3), sizeof(float), 1, input);
	fread(&(rty3), sizeof(float), 1, input);

	fread(&(texname), sizeof(char), 256, input);

	textures.begin();
	while(t = textures.get()) {
		if(strcmp(t->filename, texname) == 0) {
			texture = t;
			break;
		}
	}
}