#include "particle.h"

Particle::Particle(Object *parent, Atom *me, Texture *tex, int life, float size, float depth, float r, float g, float b, float a, float rch, float gch, float bch, float ach) : LifeAtom(parent, me, life) {
	startlife = life;
	this->life = startlife;
	rstartlife = 1.0f / startlife;
	this->size = size;
	hsize = size * 0.5f;
	me->draw = false;
	this->tex = tex;
	this->depth = depth;
	this->r = r;
	this->g = g;
	this->b = b;
	this->a = a;
	this->rch = rch;
	this->gch = gch;
	this->bch = bch;
	this->ach = ach;
}

inline void Particle::draw()  {
	if(tex) {
		float decay = 1 - life * rstartlife;
		glColor4f(r + rch * decay, g + gch * decay, b + bch * decay, a + ach * decay);
		glBindTexture(GL_TEXTURE_2D, tex->texID);

		glEnable(GL_TEXTURE_2D);
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f, 0.0f);	glVertex3f(me->x - hsize, me->y - hsize, depth);
			glTexCoord2f(1.0f, 0.0f);	glVertex3f(me->x + hsize, me->y - hsize, depth);
			glTexCoord2f(1.0f, 1.0f);	glVertex3f(me->x + hsize, me->y + hsize, depth);
			glTexCoord2f(0.0f, 1.0f);	glVertex3f(me->x - hsize, me->y + hsize, depth);
		glEnd();
		glDisable(GL_TEXTURE_2D);
	}
	else {
		glPointSize(15.0f);
		glColor4f(r, g, b, life * rstartlife);
		glBegin(GL_POINTS);
			glVertex3f(me->x, me->y, 1.0f);
		glEnd();
	}

	Object::draw();
}