#include "object.h"

Object::Object(Object *parent) {
	this->parent = parent;
	if(parent != NULL) this->parent->children.add(this);
	being_deleted = false;
	draw_order = 0;
}

Object::~Object() {
	being_deleted = true;
	if(parent) parent->removeObject(this);
}

void Object::destroy() {
	being_deleted = true;
}

void Object::setDrawOrder(int draw_order) {
	this->draw_order = draw_order;
	parent->children.remove(this);

	Object *o;
	parent->children.begin();
	while((o = parent->children.get()) && (o->draw_order < draw_order)) ;
	parent->children.insert(this);
}

void Object::assignAtomGroup(int group) {
	assigned_atom_groups.add(new int(group));
}

void Object::assignLinkGroup(int group) {
	assigned_link_groups.add(new int(group));
}

Atom *Object::placeAtom(Atom *a) {
	Object *c;
	children.begin();
	while(c = children.get()) {
		int *i;
		c->assigned_atom_groups.begin();
		while(i = c->assigned_atom_groups.get()) {
			if(a->group == *i) {
				c->placeAtom(a);
				return a;
			}
		}
	}

	//goes here if none of the children want it (reverse orphan?)
	a->object = this;
	addAtom(a);

    return a;
}

Link *Object::placeLink(Link *l) {
	Object *c;
	children.begin();
	while(c = children.get()) {
		int *i;
		c->assigned_link_groups.begin();
		while(i = c->assigned_link_groups.get()) {
			if(l->group == *i) {
				c->placeLink(l);
				return l;
			}
		}
	}

	//goes here if none of the children want it (reverse orphan?)
	l->object = this;
	addLink(l);

    return l;
}

Poly *Object::placePoly(Poly *p) {
	addPoly(p);
	return p;
}

void Object::addAtom(Atom *a) {
	parent->addAtom(a);
	a->object = this;
}

void Object::addLink(Link *l) {
	parent->addLink(l);
	l->object = this;
}

void Object::addPoly(Poly *p) {
	parent->addPoly(p);
	p->object = this;
}

Texture *Object::addTexture(Texture *t) {
	parent->addTexture(t);
	return t;
}

StaticObject *Object::addStaticObject(StaticObject *o) {
	return parent->addStaticObject(o);
}

void Object::removeAtom(Atom *a) {
	parent->removeAtom(a);
	removed_atoms++;
}

void Object::removeLink(Link *l) {
	parent->removeLink(l);
	removed_links++;
}

void Object::removePoly(Poly *p) {
	parent->removePoly(p);
	removed_polys++;
}

void Object::removeObject(Object *o) {
	children.remove(o);
}

void Object::load(const char *fn, float offx, float offy)
{
	FILE *input = fopen(fn, "rb");
	load(input, offx, offy);
	fclose(input);
}

void Object::load(FILE *input, float offx, float offy)
{
	int i, tmp;
	PhysList<Atom> atoms;
	PhysList<Texture> textures;

	Atom *a;
	fread(&(tmp), sizeof(int), 1, input);
	for(i = 0; i < tmp; i++) {
		a = new Atom();
		a->load(input, offx, offy);
		placeAtom(a);
		atoms.add(a);
	}
	
	Link *l;
	fread(&(tmp), sizeof(int), 1, input);
	for(i = 0; i < tmp; i++) {
		l = new Link();
		l->load(input, atoms, offx, offy);
		l->draw = false;
		l->a->addLink(l);
		l->b->addLink(l);
		placeLink(l);
	}

	Texture *t;
	fread(&(tmp), sizeof(int), 1, input);
	for(i = 0; i < tmp; i++) {
		t = new Texture();
		t->load(input);
		addTexture(t);
		textures.add(t);
	}
	
	Poly *p;
	fread(&(tmp), sizeof(int), 1, input);
	for(i = 0; i < tmp; i++) {
		p = new Poly();
		p->load(input, atoms, textures, offx, offy);
		addPoly(p);
	}
}

bool Object::allowRepulse(Atom *a, Atom *b) {
	return parent->allowRepulse(a, b);
}

void Object::onRepulse(Atom *a, Atom *b, float force) {
	parent->onRepulse(a, b, force);
}
	
void Object::stepFunc() {
	Object *o;
	children.begin();
	while(o = children.get()) {
		o->stepFunc();
	}
}

void Object::atomFunc(Atom *a) {
	parent->atomFunc(a);
}

void Object::draw() {
	Object *o;
	children.begin();
	while(o = children.get()) {
		o->draw();
	}
}