#include "multiatomdir.h"

void MultiAtomDir::addFront(Atom *a) {
	front.add(a);
}

void MultiAtomDir::addBack(Atom *a) {
	back.add(a);
}

void MultiAtomDir::calc() {
	Atom *a;
	float tmp;
	int nf = 0, nb = 0;
	float fx, fy;

	fx = fy = 0;
	x = y = 0;
	ix = iy = 0;
	
	front.begin();
	while(a = front.get()) {
		fx += a->x;
		fy += a->y;
		nf++;
	}

	back.begin();
	while(a = back.get()) {
		x += a->x;
		y += a->y;
		ix += a->x - a->ox;
		iy += a->y - a->oy;
		nb++;
	}

	tmp = 1.0f / nf;
	fx *= tmp;
	fy *= tmp;
	ix *= tmp;
	iy *= tmp;

	tmp = 1.0f / nb;
	x *= tmp;
	y *= tmp;

	dx = fx - x;
	dy = fy - y;
	tmp = 1 / sqrt(dx * dx + dy * dy);
	dx *= tmp;
	dy *= tmp;
}