#include "link.h"

Link::Link(Atom *a, Atom *b, float rl, float lbp, float ubp, float k, int rigidity) {
	init();

	this->a = a;
	this->b = b;
	if(rl == -1.0f && a && b) {
		float dx = b->x - a->x;
		float dy = b->y - a->y;
		rl = sqrt(dx * dx + dy * dy);

		//a->weight += 1.0f;
		//b->weight += 1.0f;
		//a->rw = 1.0f / a->weight;
		//b->rw = 1.0f / b->weight;
		a->addLink(this);
		b->addLink(this);
		a->draw = false;
		b->draw = false;
	}
	this->rl = rl;
	this->lbp = lbp;
	this->ubp = ubp;
	this->k = k;
	this->rigidity = rigidity;
	reset_interactions = true;
}

Link::~Link() {
	being_deleted = true;

	a->removeLink(this);
	b->removeLink(this);
	object->removeLink(this);
}

void Link::init() {
	draw = true;
	a = NULL;
	b = NULL;
	object = NULL;
	being_deleted = false;
	
	group = 0;
	numpolys = 0;
}

bool Link::in(Object *o) {
	return (o && (object == o || in(o->parent)));
}

void Link::update() {
	float mult;
	float dx, dy;

	dx = a->x - b->x;
	dy = a->y - b->y;

	mult = float(rl / sqrt(dx * dx + dy * dy));
	if(mult < lbp || mult > ubp) {
		delete this;
		return;
	}
	if(mult > 100) mult = 100.0f;

	float comp = 1.0f / (a->rm + b->rm);
	float forcex = k * comp * (dx * mult - dx);
	float forcey = k * comp * (dy * mult - dy);

	a->fx += forcex;
	a->fy += forcey;

	b->fx -= forcex;
	b->fy -= forcey;

	return;
}

void Link::addPoly(Poly *p) {
	numpolys++;
	draw = false;
}

void Link::removePoly(Poly *p) {
	numpolys--;
	if(numpolys == 0) draw = true;
}

void Link::save(FILE *output) {
	fwrite(&(a->x), sizeof(float), 1, output);
	fwrite(&(a->y), sizeof(float), 1, output);
	fwrite(&(b->x), sizeof(float), 1, output);
	fwrite(&(b->y), sizeof(float), 1, output);
	fwrite(&(rl), sizeof(float), 1, output);
	fwrite(&(lbp), sizeof(float), 1, output);
	fwrite(&(ubp), sizeof(float), 1, output);
	fwrite(&(k), sizeof(float), 1, output);
	fwrite(&(mrat), sizeof(float), 1, output);
	fwrite(&(rigidity), sizeof(int), 1, output);
	fwrite(&(group), sizeof(int), 1, output);
}

void Link::load(FILE *input, PhysList<Atom> atoms, float offx, float offy) {
	float ax, ay, bx, by;
	Atom *i;

	fread(&(ax), sizeof(float), 1, input);
	fread(&(ay), sizeof(float), 1, input);
	fread(&(bx), sizeof(float), 1, input);
	fread(&(by), sizeof(float), 1, input);
	ax += offx;
	ay += offy;
	bx += offx;
	by += offy;

	atoms.begin();
	while(i = atoms.get()) {
		if(i->x == ax && i->y == ay)
			a = i;
		if(i->x == bx && i->y == by)
			b = i;
	}

	fread(&(rl), sizeof(float), 1, input);
	fread(&(lbp), sizeof(float), 1, input);
	fread(&(ubp), sizeof(float), 1, input);
	fread(&(k), sizeof(float), 1, input);
	fread(&(mrat), sizeof(float), 1, input);
	fread(&(rigidity), sizeof(int), 1, input);
	fread(&(group), sizeof(int), 1, input);
}