#include "glrenderer.h"
#include "glfuncs.h"

Game *gGame;			//REALLY UGLY - JUST TEMPORARY - to get WndProc to work
Renderer *gRend;		//REALLY UGLY - JUST TEMPORARY - to get WndProc to work
LRESULT CALLBACK WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

GLRenderer::GLRenderer(Game *game, HINSTANCE &hInstance): Renderer(game)
{
	this->hInstance = hInstance;
	gGame = game;
	gRend = this;
	hWnd = NULL;
	hRC = NULL;
	hDC = NULL;
}

void GLRenderer::initializeGraphics(char *title, float w, float h,int bpp,bool fullscreen, bool resizable) {
	Renderer::initializeGraphics(title, w, h,bpp,fullscreen, resizable);
	CreateGLWindow(title,w,h,bpp,fullscreen, hInstance, hWnd, hRC, hDC, &WndProc, resizable);

	//glClearColor(0.8f, 0.8f, 0.8f, 0.0f);
}

void GLRenderer::deactivateGraphics() {
	KillGLWindow(hInstance, hWnd, hRC, hDC);
}

void GLRenderer::resize(int w, int h) {	
	Renderer::resize(w, h);
	ReSizeGLScene(w, h);
}

void GLRenderer::draw() {
	Link *l;
	Atom *a;
	Poly *p;

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();

	game->predraw();

	glColor4f(1.0f, 1.0f, 1.0f, 1.0f);

	glEnable(GL_TEXTURE_2D);
	roster->polys.begin();
	Texture *currtex = NULL;
	p = roster->polys.get();
	while(p) {
		glBindTexture(GL_TEXTURE_2D, p->texture->texID);
		currtex = p->texture;
		glBegin(GL_TRIANGLES);
			while(p && p->texture == currtex) {
				if(p->draw) {
					glTexCoord2f(p->rtx1, p->rty1);	glVertex3f(*(p->x1), *(p->y1), 0.1f);
					glTexCoord2f(p->rtx2, p->rty2);	glVertex3f(*(p->x2), *(p->y2), 0.1f);
					glTexCoord2f(p->rtx3, p->rty3);	glVertex3f(*(p->x3), *(p->y3), 0.1f);
				}
				p = roster->polys.get();
			}
		glEnd();
	}
	glDisable(GL_TEXTURE_2D);

	glColor3f(0.00f, 1.00f, 0.00f);

	glBegin(GL_LINES);

	roster->links.begin();
	while(l = roster->links.get()) {
		if(l->draw) {
			glVertex3f(l->a->x, l->a->y, 0.2f);
			glVertex3f(l->b->x, l->b->y, 0.2f);
		}
	}
	glEnd();

	glPointSize(5);

	glColor3f(0.0f, 1.0f, 0.0f);
	glBegin(GL_POINTS);

	roster->atoms.begin();
	while(a = roster->atoms.get())
		if(a->draw)
			glVertex3f(a->x, a->y, 0.3f);

	glEnd();

	game->draw();

	SwapBuffers(hDC);
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)												// Check For Windows Messages
	{
		case WM_SYSCOMMAND:
		{
			switch (wParam)
			{
				case SC_SCREENSAVE:								// Screensaver Trying To Start?
				case SC_MONITORPOWER:							// Monitor Trying To Enter Powersave?
				return 0;										// Prevent From Happening
			}
			break;
		}

		case WM_CLOSE:
		{
			PostQuitMessage(0);
			return 0;
		}

		case WM_KEYDOWN:
		{
			gGame->keyDown(wParam);
			return 0;
		}

		case WM_KEYUP:
		{
			gGame->keyUp(wParam);
			return 0;
		}

		case WM_SIZE:
		{
			gRend->resize(LOWORD(lParam),HIWORD(lParam));				// LoWord=Width, HiWord=Height
			return 0;											// Jump Back
		}

		case WM_LBUTTONDOWN:
		{
			/* if we don't set the capture we won't get mouse move
				messages when the mouse moves outside the window. */
			SetCapture(hWnd);
			gGame->mouseMove(LOWORD(lParam), HIWORD(lParam));
			gGame->lmbDown();
			return 0;
		}

		case WM_RBUTTONDOWN:
		{
			SetCapture(hWnd);
			gGame->mouseMove(LOWORD(lParam), HIWORD(lParam));
			gGame->rmbDown();
			return 0;
		}

		case WM_LBUTTONUP:
		{
			ReleaseCapture();
			gGame->lmbUp();
			return 0;
		}
		
		case WM_RBUTTONUP:
		{
			ReleaseCapture();
			gGame->rmbUp();
			return 0;
		}

		case WM_MOUSEMOVE:
		{
			int tmp1, tmp2;
			tmp1 = LOWORD(lParam);
			tmp2 = HIWORD(lParam);
			if(tmp1 & 1 << 15) tmp1 -= (1 << 16);
			if(tmp2 & 1 << 15) tmp2 -= (1 << 16);

			gGame->mouseMove(tmp1, tmp2);
			return 0;
		}

	}

	// Pass unhandled messages to the Renderer's default WindowProc
	return DefWindowProc(hWnd,uMsg,wParam,lParam);
}