#include "game.h"

Game::Game(int compframes) : Roster(NULL) {
	int i;

	this->compframes = compframes;
	for(i = 0; i < 256; i++) keys[i] = false;
	quit = false;
	parent = NULL;
	paused = false;
	lmb = false;
	rmb = false;
}

Game::~Game() {
	//needed because has no parent, so special case
}

void Game::initializeDisplay(char *title, int screenWidth, int screenHeight, int bytesPerPixel, bool fullScreen, bool resizable)
{
	renderer->initializeGraphics(title, screenWidth, screenHeight, bytesPerPixel, fullScreen, resizable);
}

void Game::deactivateDisplay() {
	renderer->deactivateGraphics();
}

void Game::keyDown(int key)
{
	keys[key] = true;
}

void Game::keyUp(int key)
{
	keys[key] = false;
}

void Game::mouseMove(int x, int y) {
	mouse_x = x;
	mouse_y = renderer->windowh - y;
}

void Game::lmbDown() {
	lmb = true;
}

void Game::lmbUp() {
	lmb = false;
}

void Game::rmbDown() {
	rmb = true;
}

void Game::rmbUp() {
	rmb = false;
}

void Game::addAtom(Atom *a) {
	Atom *k;
	atoms.begin();
	while((k = atoms.get()) && (k->rigidity > a->rigidity)) ;
	atoms.insert(a);

	system->addAtom(a);
	a->object = this;
}

void Game::addLink(Link *l) {	
	Link *i;
	links.begin();
	while((i = links.get()) && (i->rigidity > l->rigidity)) ;
	links.insert(l);

	system->addLink(l);	
	l->object = this;
}

void Game::addPoly(Poly *p) {
	Poly *k;
	polys.begin();
	while((k = polys.get()) && k->texture < p->texture) ;
	polys.insert(p);

	renderer->addPoly(p);
	p->object = this;
}

Texture *Game::addTexture(Texture *t) {
	//this is just a stump. The only reason it propogated down this far was in case any Rosters wanted to keep track of which textures they owned
	return t;
}

StaticObject *Game::addStaticObject(StaticObject *o) {
	o->draw_order = -99;
	static_objects.prepend(o);
	return o;
}

void Game::removeAtom(Atom *a) {
	system->removeAtom(a);
	atoms.remove(a);
	removed_atoms++;
}

void Game::removeLink(Link *l) {
	system->removeLink(l);
	renderer->removeLink(l);
	links.remove(l);	
	removed_links++;
}

void Game::removePoly(Poly *p) {
	polys.remove(p);
	removed_polys++;
	//Roster::removePoly();
	//renderer->removePoly(p);
}

bool Game::allowRepulse(Atom *a, Atom *b) {
	return true;
}

void Game::onRepulse(Atom *a, Atom *b, float force) {
	//needed because no parent (sob!)
}

void Game::stepFunc() {
	if(paused) return;

	Roster::stepFunc();
	system->update();
	if(system->frame % compframes == 0) renderer->draw();
}

void Game::atomFunc(Atom *a) {
	//note: no call to parent because special case: no parent
	StaticObject *o;
	static_objects.begin();
	while(o = static_objects.get()) o->atomFunc(a);
}

void Game::predraw() {
}