#include "dgun.h"

DGun::DGun(Object *parent, bool *trigger, Direction *direction, float force, float offset, int cool_down, int life, float mass): Object(parent) {
	this->trigger = trigger;
	this->force = force;
	this->life = life;
	this->direction = direction;
	this->offset = offset;
	this->cool_down = cool_down;
	this->mass = mass;
	temp = 0;
}

void DGun::stepFunc() {
	Object::stepFunc();

	if(*trigger && temp <= 0) {
		temp = cool_down;

		direction->calc();

		Atom *a = new Atom(direction->x + direction->dx * offset + direction->ix, direction->y + direction->dy * offset + direction->iy, mass, direction->dx * force + direction->ix, direction->dy * force + direction->iy);
		new LifeAtom(this, a, life);

		a->interpolate = true;
	}
	else
		temp--;
}