#include "debrisitem.h"

DebrisItem::DebrisItem(Object *parent, Atom *me, Texture *tex) : Object(parent) {
	this->me = me;
	this->tex = tex;
	me->draw = false;
	angle = 0;
	offx = -tex->w * 0.5f;
	offy = -tex->h * 0.5f;
	me->rigidity = 10;
}

void DebrisItem::removeAtom(Atom *a) {
	Object::removeAtom(a);

	if(a == me)
		delete this;
}

void DebrisItem::stepFunc() {
	if(being_deleted)
		delete this;
}

void DebrisItem::draw() {
	Object::draw();
	
	//if(me->x - 5 > lx && me->x + 5 < rx || 1) {
	float ix = me->x - me->ox;
	float iy = me->y - me->oy;

	if(ix > .1f || iy > .1f) {
		angle = atan2(iy, ix);
		angle *= 57.295f;
	}
	
	glPushMatrix();
	
	glTranslatef(me->x, me->y, 0);
	glRotatef(angle,0,0,1);
	glBindTexture(GL_TEXTURE_2D, tex->texID);
	glBegin(GL_QUADS);
		glTexCoord2f(0, 0); glVertex2f(-offx, -offy);
		glTexCoord2f(1, 0); glVertex2f(offx, -offy);
		glTexCoord2f(1, 1); glVertex2f(offx, offy);
		glTexCoord2f(0, 1); glVertex2f(-offx, offy);
	glEnd();
		
	glPopMatrix();
	//}
}