#include "debris.h"
#include "debrisitem.h"
#include "2dgraphics.h"

Debris::Debris(Object *parent, Roster *roster, Texture *debris_tex, Texture *debris_mask, const int level, const bool levels[MAXLEVELS], float depth) : Object(parent) {
	int i;

	this->roster = roster;
	this->debris_tex = debris_tex;
	this->debris_mask = debris_mask;
	this->level = level;
	this->depth = depth;
	for(i = 0; i < MAXLEVELS; i++) {
		this->levels[i] = levels[i];
	}
	//this->level = 46;
	this->levels[46] = true;
}

void Debris::wrapDebris(Atom *a) {
	Poly *p;
	Roster *r;
	float tx, ty;
	r = roster;
	r->polys.begin();
	while(p = r->polys.get()) {
		if(p->a1 == a) {
			tx = p->tx1;
			ty = p->ty1;
			break;
		}
		else if(p->a2 == a) {
			tx = p->tx2;
			ty = p->ty2;
			break;
		}
		else if(p->a3 == a) {
			tx = p->tx3;
			ty = p->ty3;
			break;
		}
	}
	if(!p) return;

	Texture *tex;
	tex = new Texture(16, 16, 32);

	Texture *texture;
	//texture = ((Roster *)(a->object))->textures.head.next->datum;
	texture = p->texture;
	//blit(texture, tex, tx - 8, ty - 8, 0, 0, 16, 16);
	blit(texture, tex, tx, ty, 0, 0, 16, 16);
	//checktransdeb(a);
	//if(!a->transdeb) {
		blitalpha(debris_tex, debris_mask, tex, 0, 0, 0, 0, 16, 16);

	tex->createTexture();

	new DebrisItem(this, a, tex);
}

bool checkTrans(Texture *tex) {
	int x, y;
	int total = 0;
	int trans = 0;
	bool mag = false;
	for(x = 0; x < tex->w; x++) {
		for(y = 0; y < tex->h; y++) {
			if(getpixelalpha(tex, x, y) == 0.0f) {
				trans++;
			}
			total++;
		}
	}
	return (trans / (float)total > 0.5f);
}

void Debris::removePoly(Poly *p) {
	float x, y, tx, ty, ax, ay;
	x = (p->a1->x + p->a2->x + p->a3->x) * 0.33333f;
	y = (p->a1->y + p->a2->y + p->a3->y) * 0.33333f;
	tx = (p->tx1 + p->tx2 + p->tx3) * 0.33333f;
	ty = (p->ty1 + p->ty2 + p->ty3) * 0.33333f;

	/*

	const Texture *scorch = new Texture("scorch.tga");
	//debrisblit(scorch, p->texture, 0, 0, tx - 20, ty - 20, 40, 40);
	float mx, my;
	float cx, cy;
	for(mx = p->tx1, my = p->ty1, cx = (p->tx2 - p->tx1) * 0.333f, cy = (p->ty2 - p->ty1) * 0.333f; fabs(mx - p->tx2) > 0.1f || fabs(my - p->ty2) > 0.1f; mx += cx, my += cy) {
		printf("%f, %f!\n", mx, my);
		debrisblit(scorch, p->texture, 0, 0, mx - 8, my - 8, 15, 15);
	}
	for(mx = p->tx2, my = p->ty2, cx = (p->tx3 - p->tx2) * 0.333f, cy = (p->ty3 - p->ty2) * 0.333f; fabs(mx - p->tx3) > 0.1f || fabs(my - p->ty3) > 0.1f; mx += cx, my += cy) {
		printf("%f, %f!\n", mx, my);
		debrisblit(scorch, p->texture, 0, 0, mx - 8, my - 8, 15, 15);
	}
	for(mx = p->tx3, my = p->ty3, cx = (p->tx1 - p->tx3) * 0.333f, cy = (p->ty1 - p->ty3) * 0.333f; fabs(mx - p->tx1) > 0.1f || fabs(my - p->ty1) > 0.1f; mx += cx, my += cy) {
		printf("%f, %f!\n", mx, my);
		debrisblit(scorch, p->texture, 0, 0, mx - 8, my - 8, 15, 15);
	}
	
	glBindTexture(GL_TEXTURE_2D, p->texture->texID);
	
	
	int lx, ly, w, h;
	lx = tx - 20;
	ly = ty - 20;
	w = 40;
	h = 40;
	if(lx < 0) lx = 0;
	if(ly < 0) ly = 0;
	if(w > p->texture->w - lx) w = p->texture->w - lx;
	if(h > p->texture->h - ly) h = p->texture->h - ly;


	Texture *tmp;
	tmp = new Texture(w, h, 32);
	blit(p->texture, tmp, lx, ly, 0, 0, w, h);

	glTexSubImage2D(GL_TEXTURE_2D, 0, lx, ly, w, h, GL_RGBA, GL_UNSIGNED_BYTE, tmp->imageData);


	*/

	if(removed_polys % 4 != 0) {
		Object::removePoly(p);
		return;
	}

	ax = ((p->a1->x - p->a1->ox) + (p->a2->x - p->a2->ox)  + (p->a3->x - p->a3->ox)) * 0.33333f;
	ay = ((p->a1->y - p->a1->oy) + (p->a2->y - p->a2->oy)  + (p->a3->y - p->a3->oy)) * 0.33333f;

	Atom *a;
	a = new Atom(x, y, 1.0f, ax, ay, level, levels);
	Texture *tex;
	tex = new Texture(16, 16, 32);

	blit(p->texture, tex, tx - 8, ty - 8, 0, 0, 16, 16);

	if(!checkTrans(tex)) {
		blitalpha(debris_tex, debris_mask, tex, 0, 0, 0, 0, 16, 16);
	}
	else {
		Color c;
		int x, y, r1, g1, b1, r2, g2, b2, rf, gf, bf;
		r2 = 40;
		g2 = 40;
		b2 = 40;
		int dist, gd;
		float al = .5;
		for(x = 0; x < tex->w; x++) {
			for(y = 0; y < tex->h; y++) {
				c = getpixel(tex, x, y); 
				//if(c != magenta) {
				if(1) {
					r1 = c.r;
					g1 = c.g;
					b1 = c.b;
					dist = r2 - r1;
					gd = al * dist;
					rf = r1 + gd;
					dist = g2 - g1;
					gd = al * dist;
					gf = g1 + gd;
					dist = b2 - b1;
					gd = al * dist;
					bf = b1 + gd;
					putpixel(tex, x, y, Color(rf, gf, bf, c.a));
				}
			}
		}
		//draw_trans_sprite(tex, debriso1, 0, 0);
	}

	tex->createTexture();
	DebrisItem *d = new DebrisItem(this, a, tex);
	d->addAtom(a);


	/*
	*/

	Object::removePoly(p);		
}

void Debris::removeLink(Link *l) {
	Object::removeLink(l);

	if(l->a->numlinks == 0)
		l->a->being_deleted = true;
		//wrapDebris(l->a);
	if(l->b->numlinks == 0)
		l->b->being_deleted = true;
		//wrapDebris(l->b);

	//Object::removeLink(l);
}

void Debris::draw() {
	glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
	glTranslatef(0.0f, 0.0f, depth);
	glEnable(GL_TEXTURE_2D);

	Object::draw();			//draw all the wee chilluns

	glDisable(GL_TEXTURE_2D);
	glTranslatef(0.0f, 0.0f, -depth);
}