#include "dactuator.h"

DActuator::DActuator(Object *parent, Direction *direction) : Object(parent) {
	this->direction = direction;
}

void DActuator::applyForce(float force) {
	direction->calc();

	fx = direction->dx * force;
	fy = direction->dy * force;
}

void DActuator::stepFunc() {
	Object::stepFunc();

	fx = 0;
	fy = 0;
}

void DActuator::atomFunc(Atom *a) {
	a->fx += fx;
	a->fy += fy;

	Object::atomFunc(a);
}