#ifndef TEXTURE_H
#define TEXTURE_H

#include "windows.h"
#include "color.h"
#include <gl\gl.h>										// Header for OpenGL32 library
#include <stdio.h>

struct Texture {
	GLubyte	*imageData;										// Image Data (Up To 32 Bits)
	int datasize;
	GLuint	bpp;											// Image Color Depth In Bits Per Pixel
	int bypp;
	GLuint	width;											// Image Width
	GLuint	height;											// Image Height
	int w;
	int h;
	GLuint	texID;											// Texture ID Used To Select A Texture
	GLuint	type;											// Image Type (GL_RGB, GL_RGBA)
	char filename[256];

	Texture();
	Texture(char *fn);
	Texture(int w, int h, int bpp);
	void init();
	void init(char *fn);
	void createTexture();
	Color getPixel(int x, int y);
	void save(FILE *output);
	void load(FILE *input);
};

#endif