#ifndef SYSTEM_H
#define SYSTEM_H

#define MAXATOMS 5000
#define MAXLINKS 5 * MAXATOMS
#define MAXOBJECTS 100
#define INTERACTTABLESIZE (MAXATOMS * MAXATOMS)
#define CONTAINERW 1002
#define CONTAINERH 1002

struct System;

#include "physlist.h"
#include "atom.h"
#include "link.h"
#include "container.h"
#include <bitset>

#include "roster.h"

struct System {
	float width;
	float height;
	float rcontainerw;
	float rcontainerh;
	float gravity;						//typically negative

	int highest_rigidity;

	unsigned int frame;					//the frame counts how many calls to update() have been made
	unsigned int tick;					//the tick increases every time atoms are placed into containers

	Roster *roster;
	
	Container containers[CONTAINERW][CONTAINERH];	//containers subdivide the world into boxes of size (1/rcontainerw), (1/rcontainerh). Atoms are placed in these boxes during updates to make finding neighbors easier. See Container

	std::bitset<INTERACTTABLESIZE> interacttable;	//a table of size MAXATOMS x MAXATOMS. interacttable[i][j] is true if atoms i and j repel each other, false otherwise. Generally interacttable[i][j] is set to false when a link between a and j is created
	std::bitset<MAXATOMS> atom_indices;

	System(Roster *roster, float width = 1000.0f, float height = 1000.0f, float gravity = -0.05f, float rcontainerw = 0.1f, float rcontainerh = 0.1f);
	void resize(int w, int h);
	Atom *addAtom(Atom *a);
	Link *addLink(Link *l);
	void removeAtom(Atom *a);
	void removeLink(Link *l);
	void update();
};

#endif