#ifndef ROSTER_H
#define ROSTER_H

#include "object.h"

struct Roster : public Object {
	PhysList<Atom> atoms;
	PhysList<Link> links;
	PhysList<Poly> polys;
	PhysList<Texture> textures;
	float cx, cy;

	Roster(Object *parent);
	virtual void addAtom(Atom *a);
	virtual void addLink(Link *l);
	virtual void addPoly(Poly *p);
	virtual Texture *addTexture(Texture *t);
	virtual void removeAtom(Atom *a);
	virtual void removeLink(Link *l);
	virtual void removePoly(Poly *p);
	Link *findLink(Atom *a, Atom *b);
	void estimateCenter();
	void calculateCenter();
	void applyForce(float fx, float fy);
	void applyRotation(float speed);
	void clear();

	void save(const char *fn);			//DO NOT MAKE THIS VIRTUAL - or it will screw up loading and saving because of dynamic binding
	void save(FILE *output);		//DO NOT MAKE THIS VIRTUAL - or it will screw up loading and saving because of dynamic binding
};

#endif