#ifndef REPULSEFIELD_H
#define REPULSEFIELD_H

#include <stdio.h>

#include "atom.h"

struct RepulseField {
	int **xo;
	int **yo;
	int width;
	int height;
	int x;
	int y;
	int ax;
	int ay;

	RepulseField();
	RepulseField(int width, int height);
	RepulseField(const char *fn, int xp = 0, int yp = 0);
	RepulseField(FILE *file, int xp = 0, int yp = 0);
	~RepulseField();
	void apply(Atom *a);
	void save(const char *fn);
	void save(FILE *output);
	void load(const char *fn);
	void load(FILE *output);
};

#endif