#ifndef RENDERER_H
#define RENDERER_H

#define MAXPOLYS 1000
#define MAXTEXTURES 100

#include "physlist.h"
#include "link.h"
#include "atom.h"
#include "poly.h"
#include "texture.h"
#include "system.h"

struct Game;
struct Roster;

struct Renderer {
	int windoww;
	int windowh;
	int compframes;

	Roster *roster;
	Game *game;

	Renderer(Game *game);
	virtual void initializeGraphics(char *title, float window_width, float window_height, int bpp = 16, bool fullscreen = false, bool resizable = false);
	virtual void deactivateGraphics();
	virtual void resize(int w, int h);
	virtual void draw();
	Poly *addPoly(Poly *p);
	void removeLink(Link *l);
};

#endif