#ifndef POLY_H
#define POLY_H

struct Poly;

#include "atom.h"
#include "link.h"
#include "texture.h"
#include <stdio.h>
#include "physlist.h"

struct Poly {
	Atom *a1, *a2, *a3;							//pointers to the atoms at each vertex. Only used to assign the position pointers (next) on load
	float *x1, *x2, *x3, *y1, *y2, *y3;		    //pointers to doubles that determine where the polygon is drawn. Generally point to the x,y coordinates of atoms
	float tx1, ty1, tx2, ty2, tx3, ty3;			//the texture coordinates - floats that determine the position on the texture each vertex is at, in pixels
	float rtx1, rty1, rtx2, rty2, rtx3, rty3;	//a conversion of the texture coordinates to floats from 0 to 1 with (0,0) being the origin and (1,1) being the upper-right corner
	Link *l1, *l2, *l3;							//the links that make up the edges of the polygon. Determined in System::addPoly
	
	Object *object;
	Texture *texture;
	bool draw;

	bool being_deleted;

	Poly();
	Poly(Atom *a, Atom *b, Atom *c);
	~Poly();
	void init();								//just initializes member variables. Only called internally.
	bool in(Object *o);
	void setTexCoords();
	
	void save(FILE *output);					//DO NOT MAKE THIS VIRTUAL - or it will screw up loading and saving because of dynamic binding
	void load(FILE *input, PhysList<Atom> atoms, PhysList<Texture> textures, float offx = 0.0f, float offy = 0.0f);	//DO NOT MAKE THIS VIRTUAL - or it will screw up loading and saving because of dynamic binding
};

#endif