#ifndef PHYSLIST_H
#define PHYSLIST_H

#define NULL 0

#include <stdio.h>

template <class T>

struct PhysList
{
	template <class T>
	struct PhysListNode {
		T *datum;
		PhysListNode *next;
		PhysListNode *prev;

		PhysListNode() {
			datum = NULL;
			prev = NULL;
			next = NULL;
		}

		PhysListNode(T *d) {
			datum = df;
			next = NULL;
		}

		PhysListNode(T *d, PhysListNode *p, PhysListNode *n) {
			datum = d;
			prev = p;
			next = n;
		}
	};

	PhysListNode<T> head;
	PhysListNode<T> *iter;
	int num;

	PhysList(): head(NULL, NULL, new PhysListNode<T>(NULL, &head, NULL)), iter(&head)
	{
		num = 0;
	}

	int length() {
		return num;
	}

	T *get() {
		iter = iter->next;
		return iter->datum;
	}

	void begin() {
		iter = &head;
	}

	T *prepend(T *t)
	{
		PhysListNode<T> *tmp = new PhysListNode<T>(t, &head, head.next);
		head.next = tmp;
		tmp->next->prev = tmp;
		num++;
		return t;
	}

	T *append(T *t)
	{
		begin();
		while(get()) ;
		iter->datum = t;
		iter->next = new PhysListNode<T>(NULL, iter, NULL);
		num++;

		return t;
	}

	T *add(T *t) {
		return prepend(t);
	}

	T *insert(T *t) {
		if(!iter->datum) {
			iter->datum = t;
			iter->next = new PhysListNode<T>(NULL, iter, NULL);
		}
		else {
			iter->prev->next = new PhysListNode<T>(t, iter->prev, iter);
			iter->prev = iter->prev->next;
		}
		num++;
		return t;
	}	

	void removeCurrent() {
		iter->prev->next = iter->next;
		iter->next->prev = iter->prev;
		PhysListNode<T> *tmp = iter;
		iter = iter->prev;
		num--;
		//fprintf(stderr, "removing %i\n", tmp->datum);
		//fprintf(stderr, "deleting %i\n", tmp);
		delete tmp;
	}

	void remove(T *t) {
		//fprintf(stderr, "called to remove %i\n", t);
		begin();
		while(get() != t);
		removeCurrent();
	}

	bool contains(T *t) {
		begin();
		while(iter = iter->next)
			if(iter->datum == t) return true;
		return false;
	}
};

#endif