#ifndef PARTICLE_H
#define PARTICLE_H

#include "lifeatom.h"

struct Particle : public LifeAtom {
	float r, g, b, a;              //initial r,g,b values
	float rch, gch, bch, ach;      //change values - how quickly they decay / increase
	int startlife;
	float rstartlife;              // 1.0 / startlife
	float size;
	float hsize;                   // 0.5 * size
	float depth;                   //depth for rendering
	Texture *tex;                  //the particle image

	Particle(Object *parent, Atom *me, Texture *tex = NULL, int life = 50, float size = 20.0f, float depth = 0.0f, float r = 1.0f, float g = 1.0f, float b = 0.0f, float a = 1.0f, float rch = 0.0f, float gch = -2.0f, float bch = 0.0f, float ach = -1.0f);
	virtual void draw();
};

#endif