#ifndef OBJECT_H
#define OBJECT_H

#define MAXOBJATOMS 5000
#define MAXOBJLINKS 5 * MAXOBJATOMS
#define MAXOBJPOLYS MAXOBJATOMS

struct Object;

#include "atom.h"
#include "link.h"
#include "poly.h"
#include "texture.h"
#include "physlist.h"
#include <stdio.h>

struct StaticObject;

struct Object {
	Object *parent;
	PhysList<Object> children;
	bool being_deleted;
	int removed_atoms;                     //how many atoms have been removed
	int removed_links;                     //how many links have been removed
	int removed_polys;                     //how many polys have been removed
	int draw_order;
	PhysList<int> assigned_atom_groups;
	PhysList<int> assigned_link_groups;

	Object(Object *parent);
	~Object();
	void destroy();
	void setDrawOrder(int draw_order);
	void assignAtomGroup(int group);
	void assignLinkGroup(int group);
	virtual Atom *placeAtom(Atom *a);
	virtual Link *placeLink(Link *l);
	virtual Poly *placePoly(Poly *p);
	virtual void addAtom(Atom *a);
	virtual void addLink(Link *l);
	virtual void addPoly(Poly *p);
	virtual Texture *addTexture(Texture *t);
	virtual StaticObject *addStaticObject(StaticObject *o);
	virtual void removeAtom(Atom *a);
	virtual void removeLink(Link *l);
	virtual void removePoly(Poly *p);
	virtual void removeObject(Object *o);
	void load(const char *fn, float offx = 0.0f, float offy = 0.0f);			//DO NOT MAKE THIS VIRTUAL - or it will screw up loading and saving because of dynamic binding
	void load(FILE *input, float offx = 0.0f, float offy = 0.0f);			//DO NOT MAKE THIS VIRTUAL - or it will screw up loading and saving because of dynamic binding
	virtual bool allowRepulse(Atom *a, Atom *b);
	virtual void onRepulse(Atom *a, Atom *b, float force);
	virtual void stepFunc();
	virtual void atomFunc(Atom *a);
	virtual void draw();
};

#endif
