#ifndef MULTIDACTUATOR_H
#define MULTIDACTUATOR_H

#include "object.h"
#include "physlist.h"

struct MultiDActuator : public Object {
	struct TriggerForce {
		bool *trigger;
		float force;

		TriggerForce(bool *trigger, float force) {
			this->trigger = trigger;
			this->force = force;
		}
	};

	PhysList<TriggerForce> triggerForces;
	float fx, fy;
	Atom *front;
	Atom *back;

	MultiDActuator(Object *parent, Atom *front, Atom *back): Object(parent) {
		this->front = front;
		this->back = back;
	}

	void addForce(bool *trigger, float force) {
		triggerForces.add(new TriggerForce(trigger, force));
	}

	virtual void stepFunc() {
		TriggerForce *tf;
		float dx, dy, div;

		dx = front->x - back->x;
		dy = front->y - back->y;
		div = 1 / sqrt(dx * dx + dy * dy);
		dx *= div;
		dy *= div;

		fx = 0;
		fy = 0;

		triggerForces.begin();
		while(tf = triggerForces.get()) {
			if(*(tf->trigger)) {
				fx += tf->force * dx;
				fy += tf->force * dy;
			}
		}
	}

	virtual bool atomFunc(Atom *a) {
		a->fx += fx;
		a->fy += fy;
		return Object::atomFunc(a);
	}
};

#endif