#ifndef MULTIACTUATOR_H
#define MULTIACTUATOR_H

#include "object.h"
#include "physlist.h"

struct MultiActuator : public Object {
	struct TriggerForce {
		bool *trigger;
		float fx, fy;

		TriggerForce(bool *trigger, float fx, float fy) {
			this->trigger = trigger;
			this->fx = fx;
			this->fy = fy;
		}
	};

	PhysList<TriggerForce> triggerForces;
	float fx, fy;

	MultiActuator(Object *parent): Object(parent) {}

	void addForce(bool *trigger, float fx, float fy) {
		triggerForces.add(new TriggerForce(trigger, fx, fy));
	}

	virtual void stepFunc() {
		TriggerForce *tf;

		fx = 0;
		fy = 0;

		triggerForces.begin();
		while(tf = triggerForces.get()) {
			if(*(tf->trigger)) {
				fx += tf->fx;
				fy += tf->fy;
			}
		}
	}

	virtual bool atomFunc(Atom *a) {
		a->fx += fx;
		a->fy += fy;
		return Object::atomFunc(a);
	}
};

#endif