#ifndef LINK_H
#define LINK_H

struct Link;

#include "atom.h"
#include "math.h"
#include "object.h"
#include <stdio.h>
#include "physlist.h"
#include "poly.h"

struct Link {
	Atom *a, *b;

	float rl;       //the rest length of the spring
	float lbp;      //the length below which the spring breaks
	float ubp;      //the length above which the spring breaks
	float k;        //the spring constant
	float mrat;     //ratio of inertialess motion
	bool draw;      //whether or not to draw the spring
	Object *object;
	int rigidity;
	bool being_deleted;
	int numpolys;   //number of polygons of which this spring is a side. Affects draw
	int group;
	bool reset_interactions;

	Link(Atom *a = NULL, Atom *b = NULL, float rl = -1.0f, float lbp = 0.8f, float ubp = 1.2f, float k = 0.20f, int rigidity = 3);
	~Link();

	void init();
	bool in(Object *o);
	void update();
	virtual void addPoly(Poly *p);
	virtual void removePoly(Poly *p);

	void save(FILE *output);			//DO NOT MAKE THIS VIRTUAL - or it will screw up loading and saving because of dynamic binding
	void load(FILE *input, PhysList<Atom> atoms, float offx = 0.0f, float offy = 0.0f);	//DO NOT MAKE THIS VIRTUAL - or it will screw up loading and saving because of dynamic binding
};

#endif