#ifndef GAME_H
#define GAME_H

#include "roster.h"
#include "system.h"
#include "renderer.h"
#include "staticobject.h"

struct Game : public Roster {
	bool keys[256];
	float mouse_x;
	float mouse_y;
	bool lmb;
	bool rmb;
	bool quit;					//a bool checked every tick in main.cpp. If true, the program quits
	int compframes;				//the number of frames computed for every frame displayed. Usually 1, but on systems with poor graphics capabilities, higher values may be a good idea
	bool paused;

	System *system;
	Renderer *renderer;
	PhysList<StaticObject> static_objects;

	Game(int compframes = 1);
	~Game();
	void initializeDisplay(char *title, int screenWidth = 800, int screenHeight = 600, int bytesPerPixel = 16, bool fullScreen = false, bool resizable = false);
	void deactivateDisplay();
	virtual void keyDown(int key);
	virtual void keyUp(int key);
	virtual void mouseMove(int x, int y);
	virtual void lmbDown();
	virtual void lmbUp();
	virtual void rmbDown();
	virtual void rmbUp();
	virtual void addAtom(Atom *a);
	virtual void addLink(Link *l);
	virtual void addPoly(Poly *p);
	virtual Texture *addTexture(Texture *t);
	virtual StaticObject *addStaticObject(StaticObject *o);
	virtual void removeAtom(Atom *a);
	virtual void removeLink(Link *l);
	virtual void removePoly(Poly *p);
	virtual bool allowRepulse(Atom *a, Atom *b);
	virtual void onRepulse(Atom *a, Atom *b, float force);
	virtual void stepFunc();
	virtual void atomFunc(Atom *a);
	virtual void predraw();
};

#endif