#ifndef DGUN_H
#define DGUN_H

#include "object.h"
#include "physlist.h"
#include "lifeatom.h"
#include "direction.h"

struct DGun : public Object {
	bool *trigger;              //when true, the gun fires
	float force;                //the force of the bullet being fired
	int life;                   //how long the bullet lives
	int cool_down;              //how long after firing the gun must wait to fire again
	int temp;                   //internally used to keep track of cooling down
	float offset;               //how far forward of the direction's position the bullet should appear
	float mass;                 //the mass of the bullet
	Direction *direction;

	DGun(Object *parent, bool *trigger = NULL, Direction *direction = NULL, float force = 0.0f, float offset = 1.0f, int cool_down = 10, int life = 50, float mass = 5.0f);
	virtual void stepFunc();
};

#endif