#ifndef DEBRIS_H
#define DEBRIS_H

#include "object.h"
#include "roster.h"

struct Debris : public Object {
	int level;
	bool levels[MAXLEVELS];
	float depth;
	Texture *debris_tex;
	Texture *debris_mask;
	Roster *roster;

	Debris(Object *parent, Roster *roster, Texture *debris_tex, Texture *debris_mask, const int level = 46, const bool levels[MAXLEVELS] = emptylevels, float depth = 1.0f);
	void wrapDebris(Atom *a);
	virtual void removePoly(Poly *p);
	virtual void removeLink(Link *l);
	virtual void draw();
};

#endif