#ifndef ATOM_H
#define ATOM_H

#define MAXLEVELS 50

const bool defaultlevels[MAXLEVELS] = {false, true, true, true, true, true, true, true, true, true, false};
const bool emptylevels[MAXLEVELS] = {false};

struct Atom;

#include <stdio.h>
#include "math.h"
#include "object.h"
//#include "link.h"
//#include "physlist.h"

struct System;
struct Link;

struct Atom {
	float x, y;        //the position of the atom
	float ox, oy;      //the old position (last update) of the atom - used for inertia
	float iox, ioy;    //for interpolate
	float fx, fy;      //the force being applied to the atom
	int rigidity;      //how many times per system update the repulse forces are calculated
	float rrigidity;   //reciprocal of rigidity
	Atom *next;        //used in containers to make atoms into linked lists
	int level;         //the level the atom exists on
	bool levels[MAXLEVELS]; //the levels the atom interacts with
	int index;         //index of atom - used only for saving / loading
	float mk;          //intertialess motion constant
	float rdist;       //distance at which atom repels other atoms
	int cx, cy;        //which container the atom is in
	bool draw;         //whether or not to draw the atom
	float mass;        //the atom's mass
	float rm;          //reciprocal of mass - this is what's actually used
	bool interpolate;  //atoms with interpolate set to true update their position rigidity times per update rather than once per update, for smoother movement. Set this to true for things like bullets that run the risk of jumping right through an object due to time steps
	float ix, iy;      //for interpolate only
	int group;         //for loading complex objects. May be removed, eventually... not sure
	int numlinks;      //number of links atom is attached to (used for determining draw)

	bool being_deleted;

	Object *object;    //object the atom belongs to - used for atomUpdate
	System *system;    //system the atom belongs to - used for bouncing off walls, gravity	Atom(float x = 0.0f, float y = 0.0f, float mass = 1.0f, float ix = 0.0f, float iy = 0.0f, int level = 1, const bool levels[MAXLEVELS] = defaultlevels, float mk = 0.1f, int rigidity = 3, float rdist = 5.0f);

	Atom(float x = 0.0f, float y = 0.0f, float mass = 1.0f, float ix = 0.0f, float iy = 0.0f, int level = 1, const bool levels[MAXLEVELS] = defaultlevels, float mk = 0.1f, int rigidity = 3, float rdist = 5.0f);
	~Atom();
	void destroy();
	void init();
	void repulse(Atom *b);
	virtual void addLink(Link *l);
	virtual void removeLink(Link *l);
	bool in(Object *o);
	void updateContainer();
	void repel();
	void update();
	void snap();
	void save(FILE *output);			//DO NOT MAKE THIS VIRTUAL - or it will screw up loading and saving because of dynamic binding
	void load(FILE *input, float offx = 0.0f, float offy = 0.0f);				//DO NOT MAKE THIS VIRTUAL - or it will screw up loading and saving because of dynamic binding
};

#endif