#include "2dgraphics.h"

void blit(const Texture *src, Texture *dst, int src_xstart, int src_ystart, int dst_xstart, int dst_ystart, int src_width, int src_height, float falpha) {
	int i,j,k;
	unsigned char *s, *d;										// Source & Destination
	int alpha;

	bool blend = (falpha != 1.0f);
	if(blend) {
		alpha = (int)(falpha * 255.0f);
		// Clamp Alpha If Value Is Out Of Range
		if( alpha > 255 ) alpha = 255;
		if( alpha < 0 ) alpha = 0;
	}

	// Check For Incorrect Blend Flag Values

    d = dst->imageData + (dst_ystart * dst->width * dst->bypp);    // Start Row - dst (Row * Width In Pixels * Bytes Per Pixel)
    s = src->imageData + (src_ystart * src->width * src->bypp);    // Start Row - src (Row * Width In Pixels * Bytes Per Pixel)

    for (i = 0 ; i < src_height && i + dst_ystart < dst->h && i + src_ystart < src->h ; i++ )							// Height Loop
    {
        s = s + (src_xstart * src->bypp);						// Move Through Src Data By Bytes Per Pixel
        d = d + (dst_xstart * dst->bypp);						// Move Through Dst Data By Bytes Per Pixel
        for (j = 0 ; j < src_width; j++ ) {					// Width Loop
            for( k = 0; k < src->bypp; k++, d++, s++) {			// "n" Bytes At A Time
				if(j + dst_xstart < dst->w && j + src_xstart < src->w && i + src_ystart >= 0 && i + dst_ystart >= 0 && j + src_xstart >= 0 && j + dst_ystart >= 0) {
					if (blend)										// If Blending Is On
						*d = ( (*s * alpha) + (*d * (255-alpha)) ) >> 8; // Multiply Src Data*alpha Add Dst Data*(255-alpha)
					else											// Keep in 0-255 Range With >> 8
						*d = *s;									// No Blending Just Do A Straight Copy
				}
            }
        }
        s = s + (src->width - (src_width + src_xstart))*src->bypp;	// Add End Of Row */
        d = d + (dst->width - (src_width + dst_xstart))*dst->bypp;	// Add End Of Row */
    }
}

void debrisblit(const Texture *src, Texture *dst, int src_xstart, int src_ystart, int dst_xstart, int dst_ystart, int src_width, int src_height) {
	int i,j,k;
	unsigned char *s, *d, alpha;										// Source & Destination
	bool overwrite;

    d = dst->imageData + (dst_ystart * dst->width * dst->bypp);    // Start Row - dst (Row * Width In Pixels * Bytes Per Pixel)
    s = src->imageData + (src_ystart * src->width * src->bypp);    // Start Row - src (Row * Width In Pixels * Bytes Per Pixel)

    for (i = 0 ; i < src_height && i + dst_ystart < dst->h && i + src_ystart < src->h; i++ )							// Height Loop
    {
        s = s + (src_xstart * src->bypp);						// Move Through Src Data By Bytes Per Pixel
        d = d + (dst_xstart * dst->bypp);						// Move Through Dst Data By Bytes Per Pixel
        for (j = 0 ; j < src_width; j++ ) {						// Width Loop
			if(*s == 255 && *(s + 1) == 0 && *(s + 2) == 255) {
				alpha = 1;
				overwrite = true;
			}
			else if(src->bpp == 32) {
				alpha = *(s + 3);
				overwrite = false;
			}
            for( k = 0; k < 3; k++, d++, s++) {			// "n" Bytes At A Time
				if(alpha != 0 && j + dst_xstart < dst->w && j + src_xstart < src->w && i + src_ystart >= 0 && i + dst_ystart >= 0 && j + src_xstart >= 0 && j + dst_ystart >= 0)
					if(overwrite)
						*d = 0;
					else if(alpha != 255)
						*d = ((*s * alpha) + (*d * (255-alpha))) >> 8;
					else						
						*d = *s;
			}
			if(overwrite)
				*d = 0;
			s++;
			d++;
        }
        s = s + (src->width - (src_width + src_xstart))*src->bypp;	// Add End Of Row */
        d = d + (dst->width - (src_width + dst_xstart))*dst->bypp;	// Add End Of Row */
    }
}

void blitalpha(const Texture *src, const Texture *srca, Texture *dst, int src_xstart, int src_ystart, int dst_xstart, int dst_ystart, int src_width, int src_height) {
	int i,j,k;
	unsigned char *s, *sa, *d;										// Source & Destination
	unsigned char alpha;

    d = dst->imageData + (dst_ystart * dst->width * dst->bypp);    // Start Row - dst (Row * Width In Pixels * Bytes Per Pixel)
    s = src->imageData + (src_ystart * src->width * src->bypp);    // Start Row - src (Row * Width In Pixels * Bytes Per Pixel)
    sa = srca->imageData + (src_ystart * srca->width * srca->bypp);    // Start Row - src (Row * Width In Pixels * Bytes Per Pixel)

    for (i = 0 ; i < src_height && i + dst_ystart < dst->h && i + src_ystart < src->h; i++ )							// Height Loop
    {
        s = s + (src_xstart * src->bypp);						// Move Through Src Data By Bytes Per Pixel
        sa = sa + (src_xstart * srca->bypp);						// Move Through Src Data By Bytes Per Pixel
        d = d + (dst_xstart * dst->bypp);						// Move Through Dst Data By Bytes Per Pixel
        for (j = 0 ; j < src_width; j++ ) {						// Width Loop
			alpha = *(s + 3);
            for( k = 0; k < src->bypp; k++, d++, s++, sa++) {			// "n" Bytes At A Time
				if(j + dst_xstart < dst->w && j + src_xstart < src->w && i + src_ystart >= 0 && i + dst_ystart >= 0 && j + src_xstart >= 0 && j + dst_ystart >= 0)
					if(k == 3)
						*d = *sa;
					else
						*d = ((*s * alpha) + (*d * (255-alpha))) >> 8;
						//*d = *s;								// No Blending Just Do A Straight Copy
           }
        }
        s = s + (src->width - (src_width + src_xstart))*src->bypp;	// Add End Of Row */
        sa = sa + (src->width - (src_width + src_xstart))*srca->bypp;	// Add End Of Row */
        d = d + (dst->width - (src_width + dst_xstart))*dst->bypp;	// Add End Of Row */
    }
}

Color getpixel(Texture *bmp, int x, int y) {
	Color rv;
	int start;

	start = (bmp->h - y - 1) * bmp->w * bmp->bypp + x * bmp->bypp;

	rv.r = bmp->imageData[start];
	rv.g = bmp->imageData[start+1];
	rv.b = bmp->imageData[start+2];
	if(bmp->bypp == 4)
		rv.a = bmp->imageData[start+3];
	else
		rv.a = 255;
	//rv = bmp->imageData[start] * 1000000 + bmp->imageData[start + 1] * 1000 + bmp->imageData[start + 2];
	return rv;
}

float getpixelalpha(Texture *bmp, int x, int y) {
	if(bmp->type == GL_RGB) return 1.0;

	int rv;
	int start;

	start = (bmp->h - y - 1) * bmp->w * bmp->bypp + x * bmp->bypp;

	rv = bmp->imageData[start + 3];
	return rv / 255.0f;
}

void putpixel(Texture *bmp, int x, int y, Color c) {
	GLubyte *start = &(bmp->imageData[(bmp->h - y - 1) * bmp->w * bmp->bypp + x * bmp->bypp]);

	*start = c.r;
	start++;
	*start = c.g;
	start++;
	*start = c.b;
	if(bmp->bypp == 4) {
		start++;
		*start = c.a;
	}
}