/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/

#include "IntegerObject.h"
#include "LineGraphObject.h"
#include "definitions.h"
#include "sharedfunctions.h"
#include <qtimer.h>
#include <qobject.h>
#include <fstream.h>

void MPPerfMon::loadObjectList() {
    ifstream instream("OList.mpm",ios::in);
    int count = 0;
    QListViewItem* currentRow;
    while(instream.peek() != EOF) {
	
	//create a new row
	if(count == 0)
	    currentRow = new QListViewItem(lstObjectList);
	
	//read the next string in
	string current;
	while(instream.peek() != '`')
	    current += (char)instream.get();
	instream.get();
	
	//add string to current row and update column position
	currentRow->setText(count,(QString)current.c_str());
	count ++;
	if(count == 7)
	    count = 0;
	
	//add string to graph objects combo box
	if(count==1)
	    cmbObjectName->insertItem((QString)current.c_str());
    }
    instream.close();
}

void MPPerfMon::loadGraphObjectList() {
    ifstream instream("GList.mpm",ios::in);
    int count = 0;
    QListViewItem* currentRow;	
    while(instream.peek() != EOF) {
	
	//create a new row
	if(count == 0)
	    currentRow = new QListViewItem(lstGraphObjects);
	
	//read the next string in
	string current;
	while(instream.peek() != '`')
	    current += (char)instream.get();
	instream.get();
	
	//add string to current row and update column position
	currentRow->setText(count,(QString)current.c_str());
	count ++;
	if(count == 10)
	    count = 0;
	
	//add string to active graph combo box
	if(count == 1)
	    cmbGraphSelect->insertItem((QString)current.c_str());
    }
    instream.close();
}

void MPPerfMon::init() {
    
    //initialize combo boxes
    cmbObjectType->insertItem("Integer");
    cmbObjectType->insertItem("Floating Point");
    cmbInputType->insertItem("File Offset");
    cmbInputType->insertItem("Memory");
    cmbGraphType->insertItem("Line Graph");
    
    //load object list
   loadObjectList();
   loadGraphObjectList();
   
   //intialize graph list
   myGraphs = new GraphList();
}

void decodeRGB(QString rgb, int &r, int &g, int &b) {
    if(rgb != NULL && rgb != "") {
	char* temp = strdup(((string)rgb).c_str());
	strtok(temp,":");
	r = atoi(strtok(NULL," "));
	strtok(NULL,":");
	g = atoi(strtok(NULL," "));
	strtok(NULL,":");
	b = atoi(strtok(NULL," "));
    }
    else {
	r=g=b=0;
    }
}

void MPPerfMon::addObjectItem()
{
    ///retrieve text and put it into the list box
    QString arg1 = txtAlias->text();
    QString arg2 = cmbObjectType->currentText();    
    QString arg3 = cmbInputType->currentText();
    QString arg4 = txtScanInterval->text();
    QString arg5 = txtInputArg1->text();
    QString arg6 = txtInputArg2->text();
    QString arg7 = txtInputArg3->text();
    new QListViewItem(lstObjectList,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    
    //insert object into graph objects combo box
    cmbObjectName->insertItem(arg1);
    cmbObjectName->setCurrentItem(0);
}

void deleteComboBoxItem(QComboBox* comboBox, QString item) {
    int numItems = comboBox->count();
    for(int a=0; a<numItems; a++) {
	if(comboBox->text(a) == item) {
	    comboBox->removeItem(a);
	    break;
	}	
    }
    
    if(numItems >=2)
	comboBox->setCurrentItem(0);
}

void MPPerfMon::deleteObjectItem()
{
    //get the item from the object list box
    QListViewItem* current = lstObjectList->selectedItem();
    
    if(current != NULL) {
	QString currentObjectText = current->text(0);
	deleteComboBoxItem(cmbObjectName,currentObjectText);
	
	//delete associated graph items
	QListViewItem* graphCurrent = lstGraphObjects->firstChild();
	while(graphCurrent != NULL) {
	    if(graphCurrent->text(1) == currentObjectText) {
		QListViewItem* temp = graphCurrent;
		graphCurrent = graphCurrent->nextSibling();
		delete temp;
	    }
	    else
		graphCurrent = graphCurrent->nextSibling();
	}
	
	delete current;
    }
}

void MPPerfMon::saveObjectList() {
    ofstream outstream("OList.mpm",ios::out);
    QListViewItem* current = lstObjectList->firstChild();
    while(current != NULL) {
	outstream << (string)current->text(0) << "`";
	outstream << (string)current->text(1) << "`";
	outstream << (string)current->text(2) << "`";
	outstream << (string)current->text(3) << "`";
	outstream << (string)current->text(4) << "`";
	outstream << (string)current->text(5) << "`";
	outstream << (string)current->text(6) << "`";
	current = current->nextSibling();
    }
    outstream.close();
}

void MPPerfMon::saveGraphObjectList() {
    ofstream outstream("GList.mpm",ios::out);
    QListViewItem* current = lstGraphObjects->firstChild();
    while(current != NULL) {
	outstream << (string)current->text(0) << "`";
	outstream << (string)current->text(1) << "`";
	outstream << (string)current->text(2) << "`";
	outstream << (string)current->text(3) << "`";
	outstream << (string)current->text(4) << "`";
	outstream << (string)current->text(5) << "`";
	outstream << (string)current->text(6) << "`";
	outstream << (string)current->text(7) << "`";
	outstream << (string)current->text(8) << "`";
	outstream << (string)current->text(9) << "`";
	current = current->nextSibling();
    }
    outstream.close();
}


void MPPerfMon::exitProgram() {
    saveObjectList();
    saveGraphObjectList();
    exit(0);
}

void MPPerfMon::addGraphObject()
{
    ///retrieve text and put it into the list box
    QString arg1 = txtGraphName->text();
    QString arg2 = cmbObjectName->currentText();    
    QString arg3 = cmbGraphType->currentText();
    QString arg4 = txtNumDataPoints->text();
    QString arg5 = txtAxesThickness->text();
    QString arg6 = txtFontSize->text();
    QString arg7 = txtGraphLineThickness->text();
    QString arg8 = "R:" + txtAxesColorRed->text() +
		  " G:" + txtAxesColorGreen->text() +
		  " B:" + txtAxesColorBlue->text();
    QString arg9 = "R:" + txtTextColorRed->text() +
		  " G:" + txtTextColorGreen->text() +
		  " B:" + txtTextColorBlue->text();
    QString arg10 = "R:" + txtGraphLineColorRed->text() +
		   " G:" + txtGraphLineColorGreen->text() +
		   " B:" + txtGraphLineColorBlue->text();
    QListViewItem* temp = new QListViewItem(lstGraphObjects,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    temp->setText(8,arg9); 
    temp->setText(9,arg10);
    
    //insert name into graph objects combo box
    cmbGraphSelect->insertItem(arg1);
    cmbGraphSelect->setCurrentItem(0);
}


void MPPerfMon::deleteGraphObject()
{
    //get the item from the graph object list box
    QListViewItem* current = lstGraphObjects->selectedItem();
    
    //delete the item
    if(current != NULL) {
	deleteComboBoxItem(cmbGraphSelect,current->text(0));
	delete current;
    }
}

void setComboBoxValue(QComboBox*& comboBox, QString value) {
    int numItems = comboBox->count();
    for(int a=0; a<numItems; a++) {
	if(comboBox->text(a) == value) {
	    comboBox->setCurrentItem(a);
	    break;
	}
    }
}

void MPPerfMon::graphObjectListChanged()
{
     //get the item from the graph object list box
    QListViewItem* current = lstGraphObjects->selectedItem();  
    
    //set the text and combo box choices    
    int r,g,b;
    if(current != NULL) {       
	txtGraphName->setText(current->text(0));
	setComboBoxValue(cmbObjectName,current->text(1));
	setComboBoxValue(cmbGraphType,current->text(2));
	txtNumDataPoints->setText(current->text(3));
	txtAxesThickness->setText(current->text(4));
	txtFontSize->setText(current->text(5));
	txtGraphLineThickness->setText(current->text(6));
	decodeRGB(current->text(7),r,g,b);
	txtAxesColorRed->setText(QString(itoa(r).c_str()));
	txtAxesColorGreen->setText(QString(itoa(g).c_str()));
	txtAxesColorBlue->setText(QString(itoa(b).c_str()));
	decodeRGB(current->text(8),r,g,b);
	txtTextColorRed->setText(QString(itoa(r).c_str()));
	txtTextColorGreen->setText(QString(itoa(g).c_str()));
	txtTextColorBlue->setText(QString(itoa(b).c_str()));
	decodeRGB(current->text(9),r,g,b);
	txtGraphLineColorRed->setText(QString(itoa(r).c_str()));
	txtGraphLineColorGreen->setText(QString(itoa(g).c_str()));
	txtGraphLineColorBlue->setText(QString(itoa(b).c_str()));
    }
}

void MPPerfMon::objectSelectionChanged()
{
     //get the item from the graph object list box
    QListViewItem* current = lstObjectList->selectedItem();  
    
    //set the text and combo box choices    
    if(current != NULL) {
	txtAlias->setText(current->text(0));
	setComboBoxValue(cmbObjectType,current->text(1));
	setComboBoxValue(cmbInputType,current->text(2));
	txtScanInterval->setText(current->text(3));
	txtInputArg1->setText(current->text(4));
	txtInputArg2->setText(current->text(5));
	txtInputArg3->setText(current->text(6));
    }
}

void MPPerfMon::updateObjectItem()
{
    QListViewItem* current = lstObjectList->selectedItem();    
    if(current != NULL) {
	QString currentObjectText = current->text(0);
            deleteComboBoxItem(cmbObjectName,currentObjectText);
	    
	//update associated graph object items
            if(currentObjectText != txtAlias->text()) {
	    QListViewItem* graphCurrent = lstGraphObjects->firstChild();	    
	    while(graphCurrent != NULL) {
		if(graphCurrent->text(1) == currentObjectText)
		    graphCurrent->setText(1,txtAlias->text());
		else
		    graphCurrent = graphCurrent->nextSibling();
	    }
	}
	
	delete current;
	addObjectItem();
    }
}

void MPPerfMon::updateGraphObject()
{
    QListViewItem* current = lstGraphObjects->selectedItem();    
    if(current != NULL) {
	deleteComboBoxItem(cmbGraphSelect,current->text(0));
	delete current;
	addGraphObject();
    }
}

void MPPerfMon::startGraph()
{
    //find the associated graph object
    QListViewItem* graphCurrent = lstGraphObjects->firstChild();
    while(graphCurrent != NULL) {
	if(graphCurrent->text(0) == cmbGraphSelect->currentText())
	    break;
	graphCurrent = graphCurrent->nextSibling();
    }
    
    //find the associated input object
    QString inputName = graphCurrent->text(1);
    QListViewItem* inputCurrent = lstObjectList->firstChild();
    while(inputCurrent != NULL) {
	if(inputCurrent->text(0) == inputName)
	    break;
	inputCurrent = inputCurrent->nextSibling();
    }
    
    //get all attributes
    string graphName = (string)graphCurrent->text(0);
    string objectName = (string)inputCurrent->text(0);
    string graphType = (string)graphCurrent->text(2);
    string objectType = (string)inputCurrent->text(1);
    string inputType = (string)inputCurrent->text(2);
    string inputArg1 = (string)inputCurrent->text(4);
    string inputArg2 = (string)inputCurrent->text(5);
    int numDatPoints = atoi(((string)graphCurrent->text(3)).c_str());    
    int scanInterval = atoi(((string)inputCurrent->text(3)).c_str());
    int inputArg3 = atoi(((string)inputCurrent->text(6)).c_str());
    
    //determine the scan type
    int inType;
    if(inputType == "File Offset")
	inType = FILEOFFSET;
    else 
	inType = MEMORY;
    
    //see what type of object this is and create that object type
    PerfMonObject* objectToGraph;
    if(objectType == "Integer") 
	objectToGraph = new IntegerObject(objectName,inType,scanInterval,inputArg1,inputArg2,inputArg3) ;
    
    //see what type of graph this is and create that graph type
    GraphObject* graphToDisplay;
    if(graphType == "Line Graph") {
	LineGraphObject* lineGraph = new LineGraphObject(graphName,numDatPoints,objectToGraph);
	lineGraph->SetAxesThickness(atoi(((string)graphCurrent->text(4)).c_str()));
	lineGraph->SetTextSize(atoi(((string)graphCurrent->text(5)).c_str()));
	lineGraph->SetGraphLineThickness(atoi(((string)graphCurrent->text(6)).c_str()));
	int r,g,b;
	decodeRGB(graphCurrent->text(7),r,g,b);
	lineGraph->SetAxesColor(r,g,b);
	decodeRGB(graphCurrent->text(8),r,g,b);
	lineGraph->SetTextColor(r,g,b);
	decodeRGB(graphCurrent->text(9),r,g,b);
	lineGraph->SetGraphLineColor(r,g,b);
	connect(lineGraph,SIGNAL(ViewerDestroyed(QString)),this,SLOT(DeleteActiveGraphEntry(QString)));
	graphToDisplay = lineGraph;
    }
    
    //start a timer to plot the graph every fixed amount of time
    graphToDisplay->StartPlot();
    
    //add entry to active graphs list
    new QListViewItem(lstActiveGraphs, (QString)(graphName.c_str()));
    myGraphs->AddGraph(graphToDisplay);
}


void MPPerfMon::ChangeInputType()
{

    if(cmbInputType->currentText() == "File Offset") {
	lblArg1->setText("File Name:");
	lblArg3->setText("File Offset:");
	lblArg2->setText("n/a");
    }
    else if(cmbInputType->currentText() == "Memory") {
	lblArg1->setText("n/a");
	lblArg2->setText("n/a");
	lblArg3->setText("Memory Address:");
    }
}


void MPPerfMon::TerminateGraph()
{
    QListViewItem* current = lstActiveGraphs->selectedItem();
    if(current != NULL) {
	QString graphName = current->text(0);
	myGraphs->RemoveGraph(graphName);
	delete current;
    }	
}

void MPPerfMon::DeleteActiveGraphEntry(QString graphName) {
    QListViewItem* current = lstActiveGraphs->firstChild();
    while(current != NULL) {
	if(current->text(0) == graphName) {
	    myGraphs->RemoveGraph(graphName);
	    delete current;
	    break;
	}
	current = current->nextSibling();
    }	
}
