#ifndef LINEGRAPHOBJECT_H
#define LINEGRAPHOBJECT_H

#include "GraphObject.h"
#include "QCanvasViewer.h"
#include <string>


class LineGraphObject : public GraphObject {
    Q_OBJECT
    
    protected:
    QCanvasLine* xAxis;
    QCanvasLine* yAxis;
    int numyLabels;
    int numxLabels;
    QCanvasText** xText;
    QCanvasText** yText;
    QCanvasLine** graphLines;
    QCanvasViewer* viewer;
    QPen axesPen;
    QPen graphLinePen;
    
    public:
    LineGraphObject(string gName,int size,PerfMonObject* in);
    void AddDataPoint(string dat);
    void StartPlot();
    QString GetGraphName();
    ~LineGraphObject();
    
    //accessors
    void SetTextColor(int r, int g, int b);
    void SetTextSize(int size);
    void SetAxesColor(int r, int g, int b);
    void SetAxesThickness(int size);
    void SetGraphLineColor(int r, int g, int b);
    void SetGraphLineThickness(int size);
    
    signals:
    void ViewerDestroyed(QString qGraphName); 
        
    protected:
    void PlotAxes();
        
    protected slots:
    void ViewerDestruction();    
    void PlotGraph();    
};

#endif
