#include <qvaluelist.h>
#include "LineGraphObject.h"
#include "IntegerDataPoint.h"
#include <string>
#include "definitions.h"
#include "sharedfunctions.h" 
#include <qcanvas.h>
#include <unistd.h>
#include <qtimer.h>

LineGraphObject::LineGraphObject(string gName,int size,PerfMonObject* in) {
    minDataPoint = "";
    maxDataPoint = "";
    maxSize = size;
    inStream = in;
    graphName = gName;
    dataPointPointer = 0;
    numDataPoints = 0;
    myCanvas.resize(600,600);
    myCanvas.setBackgroundColor(QColor(200,200,200));
    myCanvas.setUpdatePeriod(1);     
    viewer = new QCanvasViewer(&myCanvas,gName.c_str());
    viewer->setCaption((QString)(graphName.c_str())); 
    connect(viewer,SIGNAL(ViewerClosing()),this,SLOT(ViewerDestruction()));
    myTimer = new QTimer();
    if(in->GetType()==INTEGER_OBJECT) {
	myData = (DataPoint**)(new IntegerDataPoint*[size]);
	for(int a=0; a<size; a++)
	    myData[a] = new IntegerDataPoint();
    }	
    for(int a=1; a<maxSize+2; a++) {
	QCanvasLine* temp = new QCanvasLine(&myCanvas);
	temp->show();
    }
    
    //initialize pens
    graphLinePen.setWidth(2);
    axesPen.setWidth(2);
    
    //initialize graph lines
    graphLines = new QCanvasLine*[size-1];
    for(int a=0; a<size-1; a++) {
	graphLines[a] = new QCanvasLine(&myCanvas);
 	graphLines[a]->setPen(graphLinePen);
	graphLines[a]->show();
    }
    
    //initialize axes
    xAxis = new QCanvasLine(&myCanvas);
    yAxis = new QCanvasLine(&myCanvas);
    xAxis->setPen(axesPen);
    yAxis->setPen(axesPen);
    xAxis->show();
    yAxis->show();
    
    //initialize labels
    xText = new QCanvasText*[10];
    yText = new QCanvasText*[10];
    for(int a=0; a<10; a++) {
	xText[a] = new QCanvasText("",&myCanvas);
	xText[a]->show();
    }
    for(int a=0; a<10; a++) {
	yText[a] = new QCanvasText("",&myCanvas);
	yText[a]->show();
    }
 }

LineGraphObject::~LineGraphObject() {
    inStream->CloseStream();
    delete viewer;
    delete inStream;
    for(int a=0; a<maxSize; a++)
	delete myData[a];
    for(int a=0; a<maxSize-1; a++)
	delete graphLines[a];
    delete xAxis;
    delete yAxis;
    for(int a=0; a<10; a++)
	delete xText[a];
    for(int a=0; a<10; a++)
	delete yText[a];
    delete myData;
    delete myTimer;
}

void LineGraphObject::ViewerDestruction() { 
    QString qGraphName = (QString)graphName.c_str();
    emit ViewerDestroyed(qGraphName); 
}

QString LineGraphObject::GetGraphName() {  
    return (QString(graphName.c_str())); 
}

void LineGraphObject::PlotAxes() {
    
    //set newDes axes
    QCanvasItemList temp = myCanvas.allItems();      			   
    int height = myCanvas.height() - 75;
    int width = myCanvas.width() - 5;
    xAxis->setPoints(75,5,75,height);
    yAxis->setPoints(75,height,width,height);
    
    //plot axes labels
    inStream->IntervalDiv(minDataPoint,maxDataPoint,9);
    int yInterval = (height-5)/9;
    int xInterval = (width-75)/9 - 1;
    for(int a=0; a<10; a++) {
	yText[a]->setText((QString)((inStream->GetNext()).c_str()));
	yText[a]->setX(5);
	yText[a]->setY(height - yInterval*a - 5);
    }
    for(int a=0; a<10; a++) {
	xText[a]->setText((QString)itoa(a+1).c_str());
	xText[a]->setY(height+15);
	xText[a]->setX(75 + xInterval*a);
    }
}

void LineGraphObject::SetTextColor(int r, int g, int b) {
    for(int a=0; a<10; a++)
	xText[a]->setColor(QColor(r,g,b));
    for(int a=0; a<10; a++)
	yText[a]->setColor(QColor(r,g,b));
}

void LineGraphObject::SetTextSize(int size) {
    QFont temp = xText[0]->font();
    temp.setPointSize(size);
    for(int a=0; a<10; a++)
	xText[a]->setFont(temp);
    for(int a=0; a<10; a++)
	yText[a]->setFont(temp);
}

void LineGraphObject::SetAxesColor(int r, int g, int b) {
    axesPen.setColor(QColor(r,g,b));
    xAxis->setPen(axesPen);
    yAxis->setPen(axesPen);
}

void LineGraphObject::SetAxesThickness(int size) {
    axesPen.setWidth(size);
    xAxis->setPen(axesPen);
    yAxis->setPen(axesPen);
}

void LineGraphObject::SetGraphLineColor(int r, int g, int b) {
    graphLinePen.setColor(QColor(r,g,b));
    for(int a=0; a<maxSize-1; a++)
 	graphLines[a]->setPen(graphLinePen);
}

void LineGraphObject::SetGraphLineThickness(int size) {
    graphLinePen.setWidth(size);
    for(int a=0; a<maxSize-1; a++)
	graphLines[a]->setPen(graphLinePen);
}

void LineGraphObject::PlotGraph() {
    
    //add the newest data point to the graph
    AddDataPoint(inStream->Read());
    
    //plot axes
    PlotAxes();
    
    //calculate the spacing between each point on the graph and get first point
    int space = 0;
    int height = myCanvas.height()-85;
    if(numDataPoints != 1)
	space = (myCanvas.width()-85)/(maxSize-1);
    int thisX = 80;
    int thisY = height  + 5 - myData[dataPointPointer%maxSize]->GetValue(minDataPoint,maxDataPoint,height);
     
    //loop through each of the data points and draw a line on the graph
    int nextX,nextY;
    for(int a=1; a<maxSize; a++) {
	nextX = thisX+space;
	nextY = height + 5 - myData[(dataPointPointer+a)%maxSize]->GetValue(minDataPoint,maxDataPoint,height);
	cerr << "nextX: "<<nextX<<" nextY: "<<nextY<< " RealValue: "<<myData[(dataPointPointer+a)%maxSize]->GetTrueValue()<<" Calc " << myData[(dataPointPointer+a)%maxSize]->GetValue(minDataPoint,maxDataPoint,height)<<endl;
	graphLines[a-1]->setPoints(thisX,thisY,nextX,nextY);
	thisX=nextX;
	thisY=nextY;
    }
cerr << endl;
}

void LineGraphObject::StartPlot() {
    inStream->OpenStream();    
    myTimer->start(inStream->GetScanInterval());
    connect(myTimer,SIGNAL(timeout()),this,SLOT(PlotGraph()));
    viewer->show();
}

void LineGraphObject::AddDataPoint(string dat) {
    if(dataPointPointer == maxSize)
	dataPointPointer = 0;
    myData[dataPointPointer]->ChangeValue(minDataPoint,maxDataPoint,dat);
    dataPointPointer ++;
    if(numDataPoints < maxSize)
	numDataPoints++;
}
