#include "IntegerObject.h"
#include "ScanObject.h"
#include "ScanFileObject.h"
#include "ScanMemoryObject.h"
#include "definitions.h"
#include "sharedfunctions.h"

IntegerObject::IntegerObject(string alias,int scan,int interval,string arg1,string arg2,int arg3) 
{
    aliasname = alias;
    scantype = scan;
    scaninterval = interval;
    inputArg1 = arg1;
    inputArg2 = arg2;
    inputArg3 = arg3;
    intervalMax = intervalStep = currentStepPointer = 0;
}

int IntegerObject::GetType() {return INTEGER_OBJECT;}

int IntegerObject::GetScanInterval() { return scaninterval; }

void IntegerObject::IntervalDiv(string low, string high, int numParts) {
   currentStepPointer = atoi(low.c_str());
   intervalMax = atoi(high.c_str());
   intervalStep = (intervalMax-currentStepPointer)/numParts;
}

string IntegerObject::GetNext() {
    string temp = itoa(currentStepPointer);
    if(currentStepPointer > intervalMax)
	return itoa(intervalMax);
    currentStepPointer += intervalStep;
    return temp;
}

string IntegerObject::GetAlias() {return aliasname;}

void IntegerObject::OpenStream() {
    if(scantype == FILEOFFSET) 
	scanRead = new ScanFileObject(inputArg1,inputArg3);
    else if(scantype == MEMORY)
	scanRead = new ScanMemoryObject((void*)inputArg3,INTEGER_OBJECT);
}

string IntegerObject::Read() {
    return scanRead->ReadValue();
}

void IntegerObject::CloseStream() {
    delete scanRead;
}

