#include "IntegerDataPoint.h"
#include "definitions.h"
#include "sharedfunctions.h"
#include <string>

IntegerDataPoint::IntegerDataPoint() {
    myValue = 0;
}

IntegerDataPoint::IntegerDataPoint(int value) {
    myValue = value;
}

int IntegerDataPoint::GetType() {
    return INTEGER_DATA_POINT;
}

void IntegerDataPoint::ChangeValue(string &min, string &max, string newVal) {
    
    //set the new value
    myValue = atoi(newVal.c_str());
    
    //convert min and max values to integers
    int minimum,maximum;
    minimum = atoi(min.c_str());
    maximum = atoi(max.c_str());    
    if(min=="")
	minimum = myValue;
    if(max=="")
	maximum = myValue;
    
    //set new max and min
    if(myValue < minimum)
	minimum = myValue;
    if(myValue > maximum)
	maximum = myValue;
    min = itoa(minimum);
    max = itoa(maximum);
}

string IntegerDataPoint::GetTrueValue() {
    return itoa(myValue);
}

int IntegerDataPoint::GetValue(string min, string max, int windowHeight) {
    
    //convert min and max values to integer format
    int minimum,maximum;
    minimum = atoi(min.c_str());
    maximum = atoi(max.c_str());

    //check for consistency
    if(maximum == minimum)
	return 0;

    //calculate new data point value on graph
    double myRelativeLocation = (double)myValue-(double)minimum;
    if(myValue == 0)
	myRelativeLocation = 0.0; 
    double range = (double)maximum - (double)minimum;
    return (int)((myRelativeLocation/range)*(double)windowHeight);
}
