#ifndef GRAPHOBJECT_H
#define GRAPHOBJECT_H

#include <qcanvas.h>
#include <string>
#include "DataPoint.h"
#include "PerfMonObject.h"
 
class GraphObject : public QObject{
    Q_OBJECT
    
    protected:
    DataPoint** myData;
    PerfMonObject* inStream;	    
    QTimer* myTimer;
    QCanvas myCanvas;
    string minDataPoint;
    string maxDataPoint;
    string graphName;
    int dataPointPointer;
    int numDataPoints;
    int maxSize;   
       
    public:
    virtual void AddDataPoint(string dat) = 0;
    virtual void StartPlot() = 0;
    virtual QString GetGraphName() = 0;
    virtual ~GraphObject() {};
	    
    protected slots:
    virtual void PlotGraph() = 0;
};

#endif
