#include "GraphList.h"

GraphList::GraphList() { head = NULL; }

GraphList::~GraphList() {
    GraphNode* current;
    while(head != NULL) {
	current = head;
	head = head->next;
	delete current->myGraph;
	delete current;
    }
}
    

void GraphList::AddGraph(GraphObject* myGraph) {
 
    //check if there are no items on the list
    if(head == NULL) {    
	head = new GraphNode();
	head->myGraph = myGraph;
	head->next = NULL;
	return;
    }

    //find end of list
    GraphNode* current = head;
    while(current->next != NULL)
	current = current->next;

    //allocate new graphnode
    current->next = new GraphNode();
    current = current->next;
    current->myGraph = myGraph;
    current->next = NULL;
}

GraphObject* GraphList::GetGraph(int pos) {
    GraphNode* current = head;
    
    //scan list until we arrive at position
    for(int a=0; a<pos; a++)
	current = current->next;
    return current->myGraph;
}

void GraphList::RemoveGraph(QString graphName) {
    GraphNode* current;
    
    //check if there are any active graphs
    if(head == NULL)
	return;

    //if pos = 0
    if (head->myGraph->GetGraphName() == graphName) {
	current = head;
	head = head->next;
	delete current->myGraph;
	delete current;
	return;
    }

    //otherwise scan list for appropriate position
    GraphNode* temp;
    current = head;
    while(current ->next != NULL) {
	if(current->next->myGraph->GetGraphName() == graphName) {
	    temp = current->next; 
	    current = current->next->next;
	    delete temp->myGraph;
	    delete temp;
	    return;
	}
	current = current->next;
    }  
}
