package LDMS::LP;

# LP.pm
#
# Handles -CITE- and -EXPCITE- fields.
#
# $Header: /home/LDMS/cvsroot/LDMS/LDMS/LP.pm,v 1.14 2000/11/30 16:19:27 jcl53 Exp $
#

use strict;
use warnings;
use lib '..';  # Make sure all modules are included AFTER this.
use LDMS::Error;  # LDMS error module.
#use LDMS::Date;  #Date error module.
require 5.005;


BEGIN {
    use Exporter ();
    our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

    # Set our version (for module version checking).
    $VERSION = do {my @r = (q$Revision: 1.14 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r};

    @ISA = qw(Exporter);

    # Exported functions.
    @EXPORT = qw(&getCiteTitleNumber &initExpcite &getNextExpciteEntry &getExpciteLevel);
    %EXPORT_TAGS = ( );

    # Exported global variables and optional exported functions.
    @EXPORT_OK = qw();

}
our @EXPORT_OK;

# Non-exported global variables.


# Initialize exported global variables.


# Initialize non-exported global variables.


# Create private global variables.
my @expciteBlock = {};
my $expciteEntryIndex = 0;
my @expciteStartEntry = {};


# Prototype functions.
sub initCite(@);
sub getCiteTitleNumber(@);
sub initExpcite(@);
sub getNextExpciteEntry();
sub getExpciteLevel();


# Module destructor.
END { }


#initCite(@)
#output cite.
#Pre: Input is dashline stripped text.  May be multiple lines.
#Post:  Cite tag is outputted.
sub initCite(@)
{
   my @citeBlock;

   @citeBlock = shift;
   #Mark up Dates.   
   #MarkUpDate(@citeBlock);
}

#getCiteTitleNumber(@)
#returns the title number of the given Cite block
#Pre: Input is dashline stripped text.  May be multiple lines.
#Post: Returns -1 and outputs error if the first line of the cite block does 
#        not conform to the standard.  
#      Else returns the number of the title.
sub getCiteTitleNumber(@)
{
   my @titleLine; #the array that corresponds to the texts of cite dashline.
   my @titleNumberLine; #the first line of @titleLine, contains the title number.
   my $titleNum; #variable to store the title number.
   my @citeBlock = shift;  #input 

   # Two types of -CITE- blocks exist.  One is a sort of running header,
   # and the other indicates the start of a section, like a DATATEXTNAME in
   # format.  This regex covers both of them.
   if (!($citeBlock[0] =~ /^\s*\d+\s+USC\s+\S+\s+\S+/x)) 
   {
	   &printErrMsg("LP Error - Cite block text does not conform.");
	   &printErrMsg($citeBlock[0]);
	   return -1;
   }
#   @titleLine = split(/^\s*\d\sUSC\s\TITLE\s+/x, $citeBlock[0]);
   @titleLine = split(/\s+/, $citeBlock[0]);
   $titleNum = $titleLine[1];
#   @titleNumberLine = split(/\s*/,$titleLine[1]);
#   $titleNum = $titleNumberLine[0];
   if ($titleNum=~/\d+/)
   {
      return $titleNum;
   }
   else
   {
      &printErrMsg("LP Error - while processing Cite block.");
      return -1;
   }
}

##############################################################
# Expcite Level Functions

#initExpcite 
#takes as input a list of lines in the Expcite dashline block.
#Pre: the parameter is an array of text lines that are TOC catch lines.
#Post: @expciteBlock has been initialized to the input.
sub initExpcite(@)
{
   my $expciteCount;

   @expciteBlock = @_;   #the text following the Expcite Dashlien.
   $expciteEntryIndex = 0;  #Counter to keep track of the current line number.
   @expciteStartEntry = {}; #Persistent variable to store whether this line $i
                            # is a start of a new catchline.

   for (my $i = 0; $i <= $#expciteBlock; $i++)
   {
      if ($expciteBlock[$i] =~ /^\s*[A-Z|a-z]*\s\d+\s-\s/x)
      {
         $expciteStartEntry[$i] = 1; #true
      }
      else
      {
         $expciteStartEntry[$i] = 0; #false
      }
   }
}

#Returns the next entry within the expcite block.  i.e. the next catch line.
#Pre: initExpcite(@) has been called and properly set @expciteBlock
#Post: All white spacing is reduced to a single space character.
#      Returns the empty string "", if there are no more entries.
sub getNextExpciteEntry()
{
   my $entry = ""; #variable to store the line to be returned.

   if ($expciteEntryIndex <= $#expciteBlock)
   {
      $entry = $expciteBlock[$expciteEntryIndex];
   }
   else
   {
      return $entry;
   }
   $expciteEntryIndex++;
   while (($expciteEntryIndex <= $#expciteBlock) &&
	  ($expciteStartEntry[$expciteEntryIndex] == 0))
   {
      $entry = $entry." ".$expciteBlock[$expciteEntryIndex++];
   }
   $entry =~ s/\s+/ /gx;
   return $entry;
}

#getExpciteLevel()
#returns the level count within the current expcite block.
#Pre: initExpcite(@) has been called and properly set @expciteBlock
#Post: 
sub getExpciteLevel()
{
   my $expciteLine;
   my $expciteLevel = 0;
   foreach $expciteLine (@expciteBlock)
   {
      if ($expciteLine=~/^\s*[A-Z|a-z]*\s\d+\s-\s/x)
      {
        $expciteLevel++;
      }
   }

   return $expciteLevel;
}




1;
__END__;

=pod 
$Log: LP.pm,v $
Revision 1.14  2000/11/30 16:19:27  jcl53
Upped the minimum Perl interpreter version from 5.002 to 5.005, just in case someone out there does something like trying to run this script on a non-Unix system...

Revision 1.13  2000/11/28 16:27:34  jcl53
Added a little comment to the 'use lib' lines.  Modules (especially LDMS ones) should be included after them so that testing compilation with 'perl -c' works.

Revision 1.12  2000/11/21 21:10:18  jhj4
Few mod's to DTD, e.g. formation of STATGROUP entity.

Revision 1.11  2000/11/21 21:01:15  jcl53
Added the following line to all modules to make including modules less painful:

	use lib '..';

If you're using other modules, include them AFTER this line.  Thanks.

Revision 1.10  2000/11/14 18:57:32  jhj4
Additional Comments i.e. purpose, pre, post, vars.

Revision 1.9  2000/11/11 19:42:55  jcl53
Now the regex handles sections which use letters instead of numbers.  *grumble*

Revision 1.8  2000/11/11 19:27:48  jcl53
Now accepts titles from either of the two types (running header and name).

Revision 1.7  2000/11/11 18:27:41  jcl53
Changed the -CITE- tag check to be as specific as we can make it.  It might actually be a bit too specific--though I'll do a run with all the titles just to make sure...

Also added the offending -CITE- line to the error message about nonconforming -CITE- lines.

Revision 1.6  2000/11/11 16:41:22  jhj4
Fixed various comments.

Revision 1.5  2000/11/10 07:31:22  jcl53
Changed line 132 of LP.pm so that the boundary conditions are checked in a more reasonable order.

Revision 1.4  2000/11/10 06:32:20  jcl53
XMLOut has been modified to work with filehandle arguments.  This is cleaner than making a module-global filehandle to hit XML::Writer with.

LDMS::LP=>getCiteTitleNumber has been simplified a bit, for ease of debugging.  The original code is commented out.  This should change once every module's up and running.

Revision 1.3  2000/11/10 02:47:13  jcl53
LP.pm now includes cleanly.  Changed some variables to module-global, since this module seems to want to keep some idea of state--which by all means is a good thing!

Revision 1.2  2000/11/10 01:41:56  jcl53
Renamed InputModule.pm to Input.pm just because I thought it looked neat.

In fact, Input.pm has been confirmed to be loadable as a module.  The rest--I'm working on...

Speaking of the rest, the actual code from the separate script files has been C-x i'ed into the corresponding module file.  (For you non-emacs folks out there, that means they've been inserted.)  These AREN'T confirmed to work as modules.  As I said, I'm working on them...

On a final note, the 'my' keyword is our friend, folks.  Use it like Mountain Dew on an all-nighter.

Revision 1.1  2000/11/09 20:55:07  jcl53
Added skeleton Perl module files to the appropriate directory.

