package LDMS::Input;

# Input.pm
#
# Handles operations on input files.
#
# $Header: /home/LDMS/cvsroot/LDMS/LDMS/Input.pm,v 1.4 2000/11/30 16:19:27 jcl53 Exp $
#

use strict;
use warnings;
require 5.005;
use lib '..';  # Make sure all modules are included AFTER this.


BEGIN {
    use Exporter ();
    our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

    # Set our version (for module version checking).
    $VERSION = do {my @r = (q$Revision: 1.4 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r};

    @ISA = qw(Exporter);

    # Exported functions.
    @EXPORT = qw(&openFile &readLine &readBlock &closeFile &newFileName &tagBlock &testFunctions );
    %EXPORT_TAGS = ( );

    # Exported global variables and optional exported functions.
    @EXPORT_OK = qw();

}
our @EXPORT_OK;

# Non-exported global variables.


# Initialize exported global variables.


# Initialize non-exported global variables.


# Create private global variables.


# Prototype functions.
sub openFile;
sub readLine;
sub readBlock;
sub closeFile;
sub newFileName;
sub tagBlock;
sub testFunctions;


# Module destructor.
END { }



##########################################################################
#OpenFile takes a filename and returns a filehandle.
#
##########################################################################


sub openFile 
{
    my $inputFile = shift;        #inputFile is file passes to openFile.
    local *FH;                    #Intialize a filehandle.
    open(FH, $inputFile) || die "Cannot open $inputFile: $!\n";
    return *FH;
}





###########################################################################
#readLine takes a filehandle and reads in the lines of the file corresponding
#to the filehandle. The lines are stored in an array called @lineText.
#readLine returns @lineText.
########################################################################### 
sub readLine
{
    my $fileHandle = shift;
    my @lines = <$fileHandle>;
    return @lines;
}




############################################################################
#readBlock takes in a filehandle and reads in the file associated with the
#handle. It then breaks up the text into blocks using -CITE- dashline as
# a divider. The blocks are stored in an array called blockText. 
#Each block of text is flanked by the -CITE- dashline. 
#readBlock returns blockText.
############################################################################
sub readBlock
{
    my $fileHandle = shift;             #Getting the filehandle.
    my $lookAhead = "";                 #Stores current line of text read
    my $thisBlock = $lookAhead;         # Stores current block of text read
    my @blockText = ();                 #Stores the file as an array of blocks


  BLOCK: while($lookAhead = <$fileHandle>){
      $thisBlock .= $lookAhead;
      if($lookAhead =~ /^\-CITE\-/){
          push(@blockText, $thisBlock);
          $thisBlock = $lookAhead;
          next BLOCK;
      }
  }
    return @blockText
}



###############################################################################
#closeFile takes a filehandle and closes a file.
#
################################################################################
sub closeFile
{
    my $fileHandle = shift;
    close $fileHandle || die "Cannot close file: $!\n";
}



#############################################################################
#newFileName takes the name of the input file andan extension. It then creates 
#a new name with the same name as the input file but with the new extension.
#The default new extension is ".xml".
#Returns the new name.
#############################################################################
sub newFileName
{
    my $inputName = $_[0];
    my $newExt = "";
    $newExt = ".xml" unless defined($newExt=$_[1]); 
    my $newName = $inputName; 
    $newName =~ s/\.\w+$/$newExt/;


    return $newName;
}


###############################################################################
#tagBlock


###############################################################################
sub tagBlock
{
}


##Things to do
#Add interface to report errors to error modules
#Make a generic getblock function so divisions other than by -CITE_ can be done.
#Need interface to status? No for now.
#what level of tagging if any will we do in the input

1;
__END__;

=pod 
$Log: Input.pm,v $
Revision 1.4  2000/11/30 16:19:27  jcl53
Upped the minimum Perl interpreter version from 5.002 to 5.005, just in case someone out there does something like trying to run this script on a non-Unix system...

Revision 1.3  2000/11/28 16:27:34  jcl53
Added a little comment to the 'use lib' lines.  Modules (especially LDMS ones) should be included after them so that testing compilation with 'perl -c' works.

Revision 1.2  2000/11/21 21:01:15  jcl53
Added the following line to all modules to make including modules less painful:

	use lib '..';

If you're using other modules, include them AFTER this line.  Thanks.

Revision 1.1  2000/11/10 01:41:56  jcl53
Renamed InputModule.pm to Input.pm just because I thought it looked neat.

In fact, Input.pm has been confirmed to be loadable as a module.  The rest--I'm working on...

Speaking of the rest, the actual code from the separate script files has been C-x i'ed into the corresponding module file.  (For you non-emacs folks out there, that means they've been inserted.)  These AREN'T confirmed to work as modules.  As I said, I'm working on them...

On a final note, the 'my' keyword is our friend, folks.  Use it like Mountain Dew on an all-nighter.

Revision 1.1  2000/11/09 20:55:07  jcl53
Added skeleton Perl module files to the appropriate directory.
