package LDMS::Error;

# Error.pm
#
# Handles error messages.
#
# $Header: /home/LDMS/cvsroot/LDMS/LDMS/Error.pm,v 1.10 2000/12/01 18:20:27 om14 Exp $
#
# author: Omar Mehmood
# email: om14@cornell.edu
#

use strict;
use warnings;
require 5.005;
use lib '..';  # Make sure all modules are included AFTER this.


BEGIN {
    use Exporter ();
    our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

    # Set our version (for module version checking).
    $VERSION = do {my @r = (q$Revision: 1.10 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r};

    @ISA = qw(Exporter);

    # Exported functions.
    @EXPORT = qw(&initError &printErrMsg &setErr &getErr);
    %EXPORT_TAGS = ( );

    # Exported global variables and optional exported functions.
    @EXPORT_OK = qw();

}
our @EXPORT_OK;

# Non-exported global variables.


# Initialize exported global variables.


# Initialize non-exported global variables.


# Create private global variables.
my $error_LastErrorCode = "";


# Prototype functions.
sub initError();
sub printErrMsg($arg1_ErrMsg);
sub setErr($arg1_ErrorCode);
sub getErr();


# Module destructor.
END { }



######################################################################
# pre-condition:
# n/a
#
# post-condition:
# the error module is initialized and the function returns an appropriate value:
#    0 no error
#   ## one or two-digit error code
#
# purpose:
# to initialize the error module
#
# notes:
# n/a
#

sub initError()
{
    $error_LastErrorCode = 0;
    return 0;
}


######################################################################
# pre-condition:
# a message (scalar variable) is passed to the function
#
# post-condition:
# the message is output to STDERR and the function returns an appropriate value:
#    0 no error
#   ## one or two-digit error code
#
# purpose:
# to print error messages to STDERR
#
# notes:
# - this module will be extended to include a format for STDERR, 
#   which will probably include the error message, date, and time
# - the user can redirect STDERR to a specific file (outside the scope of this module)
#

sub printErrMsg($arg1_ErrMsg)
{
    my($errMsg) = @_;
    print STDERR "$errMsg\n";
    return 0;
}


######################################################################
# pre-condition:
# a message (scalar variable) is passed to the function
#
# post-condition:
# the message is stored and the function returns an appropriate value:
#    0 no error
#   ## one or two-digit error code
#
# purpose:
# to set the last error code variable, $error_LastErrorCode, 
# equal to the code passed to the function ($errorCode)
#
# notes:
# - this function does not print the code to STDERR
#

sub setErr($arg1_ErrorCode)
{
    my($errorCode) = @_;
    $error_LastErrorCode = $errorCode;
    return 0;
}


######################################################################
# pre-condition:
# n/a
#
# post-condition:
# the last saved error code is returned
#
# purpose:
# to return the last error code that was saved via setErr function
#
# notes:
# n/a
#

sub getErr()
{
    return $error_LastErrorCode;
}





1;
__END__;

=pod 
$Log: Error.pm,v $
Revision 1.10  2000/12/01 18:20:27  om14
Changes to FootRef.pm: added use for LDMS::State and uncommented out line 151 which refers to the footnote number
Added authoring for Error.pm and Footnote.pm

VS: ----------------------------------------------------------------------

Revision 1.9  2000/11/30 16:19:27  jcl53
Upped the minimum Perl interpreter version from 5.002 to 5.005, just in case someone out there does something like trying to run this script on a non-Unix system...

Revision 1.8  2000/11/28 16:27:34  jcl53
Added a little comment to the 'use lib' lines.  Modules (especially LDMS ones) should be included after them so that testing compilation with 'perl -c' works.

Revision 1.7  2000/11/21 21:01:15  jcl53
Added the following line to all modules to make including modules less painful:

	use lib '..';

If you're using other modules, include them AFTER this line.  Thanks.

Revision 1.6  2000/11/21 20:37:10  bww3
corrected a prototype mismatch, changed printErrMsg($arg1_ErrorCode)
to printErrMsg($arg1_ErrMsg) to match function - bww3 2000-11-21

Revision 1.5  2000/11/21 03:22:54  om14
I changed the wording of Error.pm to reflect the idea of error codes versus error messages in the set error and get error functions.  I also changed the variable names to read error instead of err and code instead of msg in these functions.
I added some test cases for footnotes from titles 1 and 2 to test.txt.

Revision 1.4  2000/11/10 02:52:09  jcl53
Error.pm also includes without error now.  Changed $error_LastErrMsg to be a private module-global variable.

Revision 1.3  2000/11/10 01:54:08  jcl53
Corrected a few odd things in the logs, such as the status messages left over from the template (oops).

Revision 1.2  2000/11/10 01:41:56  jcl53
Renamed InputModule.pm to Input.pm just because I thought it looked neat.

In fact, Input.pm has been confirmed to be loadable as a module.  The rest--I'm working on...

Speaking of the rest, the actual code from the separate script files has been C-x i'ed into the corresponding module file.  (For you non-emacs folks out there, that means they've been inserted.)  These AREN'T confirmed to work as modules.  As I said, I'm working on them...

On a final note, the 'my' keyword is our friend, folks.  Use it like Mountain Dew on an all-nighter.

Revision 1.1  2000/11/09 20:55:07  jcl53
Added skeleton Perl module files to the appropriate directory.
