package LDMS::DivSource;

# DivSource.pm
#
# tags the data text associated with the -SOURCE- catchline
#
# $Header: /home/LDMS/cvsroot/LDMS/LDMS/DivSource.pm,v 1.4 2000/11/30 16:19:27 jcl53 Exp $
#

use strict;
use warnings;
require 5.005;
use lib '..';  # Make sure all modules are included AFTER this.
use LDMS::XMLOut;
BEGIN {
    use Exporter ();
    our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

    # Set our version (for module version checking).
    $VERSION = do {my @r = (q$Revision: 1.4 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r};

    @ISA = qw(Exporter);

    # Exported functions.
    @EXPORT = qw(&tagDivSource);
    %EXPORT_TAGS = ( );

    # Exported global variables and optional exported functions.
    @EXPORT_OK = qw();

}
our @EXPORT_OK;

# Non-exported global variables.


# Initialize exported global variables.


# Initialize non-exported global variables.


# Create private global variables.

      
# Prototype functions.
sub tagDivSource(@);


# Module destructor.
END { }

#############################################################################
#sub tagDivSource
#Input argument during function call: Takes an array of data text associated
#with the -SOURCE- catchline.
#
#pre: the -SOURCE- catchline and the associated text is not tagged
#post: the -SOURCE- catchline is tagged as <SOURCE>.Its asociated text is
#      separated by the ';' delimiter and each such separated line is contained
#      within the <DIVSOURCE> and </DIVSOURCE> tags.After all the lines have
#      been tagged,<SOURCE> is closed with the </SOURCE> tag.

##############################################################################
sub tagDivSource(@)
{

    # Collect our block of SOURCE.
    my @divSource = @_;

    # Remove flanking whitespace.  (It looks ugly otherwise.)
    for (my $i = 0; $i < scalar(@divSource); $i++) {
    
	$divSource[$i] =~ s/^\s*//;
	$divSource[$i] =~ s/\s*$//;

    }
    
    # Turn block into a single string, so we can cut off flanking parentheses.
    my $divSourceString = join(" ", @divSource);

    # Actually de-flanking-parenthesize the string.
    $divSourceString =~ s/^\s*\(//;
    $divSourceString =~ s/\)\s*$//;

    # Split block back up, this time along semicolons.  (Cool, eh?)
    my @divSourceList = split(";", $divSourceString);

    # Actually output the darn thing.
    for (my $i = 0; $i < scalar(@divSourceList); $i++) {

	# Do the essential tags.
	&BeginTag("DIVSOURCE");
	&WriteString($divSourceList[$i]);
	&EndTag("DIVSOURCE");

	# Add a newline.  (Looks purty.)
	&WriteString("\n");

    }

 
} # end tagDivSrc

############################## END sub tagDivSrc{} #############################

1;
__END__;

=pod 
$Log: DivSource.pm,v $
Revision 1.4  2000/11/30 16:19:27  jcl53
Upped the minimum Perl interpreter version from 5.002 to 5.005, just in case someone out there does something like trying to run this script on a non-Unix system...

Revision 1.3  2000/11/29 03:51:33  jcl53
Completely rewrote the function:

	- Eliminated global variables.
	- Removed flanking whitespace.
	- Stopped the insanity.

The 'insanity' was the inflation of titles by approximately 15 times, depending on how much DIVSOURCE was present.  XML::Writer was choking to death on all of the spurious DIVSOURCE tags...

Don't worry, kids:  it's fixed now.

Revision 1.2  2000/11/28 15:01:16  jcl53
Works properly with current <SOURCE> tagging now.

Revision 1.1  2000/11/28 14:41:49  jcl53
Renamed divSourceModule.pm to DivSource.pm.

Revision 1.7  2000/11/21 21:08:54  nl42
added &'s before XMLOut functions

Revision 1.6  2000/11/21 21:02:37  nl42
preModule marks up graceful failures within the <PRE></PRE>tags

Revision 1.5  2000/11/21 21:01:15  jcl53
Added the following line to all modules to make including modules less painful:

	use lib '..';

If you're using other modules, include them AFTER this line.  Thanks.

Revision 1.4  2000/11/21 17:50:19  nl42
Removed use XML::XMLOut

Revision 1.3  2000/11/21 17:45:09  nl42
Added use XML::XMLOut

Revision 1.2  2000/11/18 15:12:24  nl42
The error in divSourceModule.pm because of the missing ; in function prototype
was corrected.
CVS : ----------------------------------------------------------------------

Revision 1.1  2000/11/18 15:06:05  nl42
divSourceModule.pm is the perl module for the divSourceModule.pl. It tags the
-SOURCE- catchline and its associated text. The associated text is separated by the ; delimiter and each such separation is tagged by the <DIVSOURCE> tag.


