package LDMS::Pre;

# Pre.pm
#
# marks up all graceful failures within <PRE></PRE> tags
# $Header: /home/LDMS/cvsroot/LDMS/LDMS/Pre.pm,v 1.5 2000/11/30 16:19:27 jcl53 Exp $
#

use strict;
use warnings;
require 5.005;
use lib '..';  # Make sure all modules are included AFTER this.
use LDMS::XMLOut;


BEGIN {
    use Exporter ();
    our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

    # Set our version (for module version checking).
    $VERSION = do {my @r = (q$Revision: 1.5 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r};

    @ISA = qw(Exporter);

    # Exported functions.
    @EXPORT = qw(&tagPre);
    %EXPORT_TAGS = ( );

    # Exported global variables and optional exported functions.
    @EXPORT_OK = qw();

}
our @EXPORT_OK;

# Non-exported global variables.


# Initialize exported global variables.


# Initialize non-exported global variables.


# Create private global variables.

# Prototype functions.
sub tagPre();

# Module destructor.
END { }

#############################################################################
#sub tagPre
#marks up all graceful failures withing the <PRE></PRE>tags
#The array containing text defining the graceful failure is passed into the 
#function at the function call
##############################################################################
sub tagPre() {

    # Acquire current unrecognized text from argument array.
    my @preText = @_;

    # Write out starting tag.
    &BeginTag("PRE");
    &WriteString("\n");

    # Write out unrecognized text.
    while (scalar(@preText) > 0) {
        my $temp = shift(@preText);
	if ($temp ne "")
        {
	   &WriteString($temp . "\n");
        } 
    }

    # Write out ending tag.
    &EndTag(); 
    &WriteString("\n");

}
############################## END sub tagPre{} ############################

1;
__END__;

=pod 
$Log: Pre.pm,v $
Revision 1.5  2000/11/30 16:19:27  jcl53
Upped the minimum Perl interpreter version from 5.002 to 5.005, just in case someone out there does something like trying to run this script on a non-Unix system...

Revision 1.4  2000/11/29 13:00:55  jhj4
*** empty log message ***

Revision 1.3  2000/11/29 04:17:52  jcl53
Did some gratuitous commenting, added newlines after the <PRE> tags.

Revision 1.2  2000/11/28 23:48:33  jcl53
Fixed the package declaration (it's not XMLOut, it's Pre).
Pretty-prints (i.e. puts newlines in) text that's <PRE> tagged.

Revision 1.1  2000/11/28 14:46:35  jcl53
Renamed preModule.pm to Pre.pm.

Revision 1.2  2000/11/21 21:08:54  nl42
added &'s before XMLOut functions

Revision 1.1  2000/11/21 21:02:37  nl42
preModule marks up graceful failures within the <PRE></PRE>tags


